/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.jdbc.ExecutedQuery;
import ortus.boxlang.runtime.jdbc.QueryOptions;
import ortus.boxlang.runtime.jdbc.QueryParameter;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;
import ortus.boxlang.runtime.types.util.ListUtil;

public class PendingQuery {
    private static final Logger logger = LoggerFactory.getLogger(PendingQuery.class);
    private static final InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();
    private static final Pattern pattern = Pattern.compile(":\\w+");
    private static final String CACHE_PREFIX = "BL_QUERY";
    @Nonnull
    private String sql;
    @Nonnull
    private final String originalSql;
    @Nonnull
    private final List<QueryParameter> parameters;
    private QueryOptions queryOptions;
    private String cacheKey;
    private ICacheProvider cacheProvider;

    public PendingQuery(@Nonnull String sql, Object bindings, QueryOptions queryOptions) {
        logger.debug("Building new PendingQuery from SQL: [{}] and options: [{}]", (Object)sql, (Object)queryOptions.toStruct());
        IStruct eventArgs = Struct.of(new Object[]{"sql", sql.trim(), "bindings", bindings, "pendingQuery", this, "options", queryOptions});
        interceptorService.announce(BoxEvent.ON_QUERY_BUILD, eventArgs);
        this.sql = eventArgs.getAsString(Key.sql);
        this.originalSql = eventArgs.getAsString(Key.sql);
        this.parameters = this.processBindings(eventArgs.get(Key.of("bindings")));
        this.queryOptions = eventArgs.getAs(QueryOptions.class, Key.options);
        this.cacheKey = this.getOrComputeCacheKey();
        this.cacheProvider = BoxRuntime.getInstance().getCacheService().getCache(this.queryOptions.cacheProvider);
    }

    public PendingQuery(@Nonnull String sql, @Nonnull List<QueryParameter> parameters) {
        this(sql, parameters, new QueryOptions(new Struct()));
    }

    private String getOrComputeCacheKey() {
        if (this.queryOptions.cacheKey != null) {
            return this.queryOptions.cacheKey;
        }
        String key = CACHE_PREFIX + this.sql.hashCode() + this.getParameterValues().hashCode();
        if (this.queryOptions.datasource != null) {
            key = key + this.queryOptions.datasource.hashCode();
        }
        if (this.queryOptions.username != null) {
            key = key + this.queryOptions.username.hashCode();
        }
        if (this.queryOptions.password != null) {
            key = key + this.queryOptions.password.hashCode();
        }
        return key;
    }

    private List<QueryParameter> processBindings(Object bindings) {
        if (bindings == null) {
            return new ArrayList<QueryParameter>();
        }
        CastAttempt<Array> castAsArray = ArrayCaster.attempt(bindings);
        if (castAsArray.wasSuccessful()) {
            return this.buildParameterList((Array)castAsArray.getOrFail());
        }
        CastAttempt<IStruct> castAsStruct = StructCaster.attempt(bindings);
        if (castAsStruct.wasSuccessful()) {
            return this.buildParameterList((IStruct)castAsStruct.getOrFail());
        }
        String className = bindings.getClass().getName();
        throw new BoxRuntimeException("Invalid type for params. Expected array or struct. Received: " + className);
    }

    private List<QueryParameter> buildParameterList(@Nonnull Array parameters) {
        return parameters.stream().map(QueryParameter::fromAny).collect(Collectors.toList());
    }

    private List<QueryParameter> buildParameterList(@Nonnull IStruct parameters) {
        ArrayList<QueryParameter> params = new ArrayList<QueryParameter>();
        Matcher matcher = pattern.matcher(this.sql);
        while (matcher.find()) {
            String paramName = matcher.group();
            Object paramValue = parameters.get(paramName = paramName.substring(1));
            if (paramValue == null) {
                throw new DatabaseException("Missing param in query: [" + paramName + "]. SQL: " + this.sql);
            }
            params.add(QueryParameter.fromAny(paramValue));
        }
        this.sql = matcher.replaceAll("?");
        return params;
    }

    @Nonnull
    public String getOriginalSql() {
        return this.originalSql;
    }

    @Nonnull
    public List<Object> getParameterValues() {
        return this.parameters.stream().map(QueryParameter::getValue).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ExecutedQuery execute(ConnectionManager connectionManager) {
        if (this.isCacheable()) {
            logger.debug("Checking cache for query: {}", (Object)this.cacheKey);
            Attempt<Object> cachedQuery = this.cacheProvider.get(this.cacheKey);
            if (cachedQuery.isPresent()) {
                return this.respondWithCachedQuery(cachedQuery);
            }
            logger.debug("Query is NOT present, continuing to execute query: {}", (Object)this.cacheKey);
        }
        Connection connection = connectionManager.getConnection(this.queryOptions);
        try {
            ExecutedQuery executedQuery = this.execute(connection);
            return executedQuery;
        }
        finally {
            if (connection != null) {
                connectionManager.releaseConnection(connection);
            }
        }
    }

    @Nonnull
    public ExecutedQuery execute(Connection connection) {
        if (this.isCacheable()) {
            Attempt<Object> cachedQuery = this.cacheProvider.get(this.cacheKey);
            if (cachedQuery.isPresent()) {
                return this.respondWithCachedQuery(cachedQuery);
            }
            ExecutedQuery executedQuery = this.executeStatement(connection);
            this.cacheProvider.set(this.cacheKey, executedQuery, this.queryOptions.cacheTimeout, this.queryOptions.cacheLastAccessTimeout);
            return executedQuery;
        }
        return this.executeStatement(connection);
    }

    private ExecutedQuery executeStatement(Connection connection) {
        try {
            ArrayList<ExecutedQuery> queries = new ArrayList<ExecutedQuery>();
            for (String sqlStatement : this.sql.split(";")) {
                boolean bl;
                Statement statement = this.parameters.isEmpty() ? connection.createStatement() : connection.prepareStatement(this.sql, 1);
                this.applyParameters(statement);
                this.applyStatementOptions(statement);
                interceptorService.announce(BoxEvent.PRE_QUERY_EXECUTE, Struct.of(new Object[]{"sql", this.sql, "bindings", this.getParameterValues(), "pendingQuery", this}));
                long startTick = System.currentTimeMillis();
                if (statement instanceof PreparedStatement) {
                    PreparedStatement preparedStatement = (PreparedStatement)statement;
                    bl = preparedStatement.execute();
                } else {
                    bl = statement.execute(sqlStatement, 1);
                }
                boolean hasResults = bl;
                long endTick = System.currentTimeMillis();
                queries.add(ExecutedQuery.fromPendingQuery(this, statement, endTick - startTick, hasResults));
            }
            return (ExecutedQuery)queries.getFirst();
        }
        catch (SQLException e) {
            String detail = "";
            if (e.getCause() != null) {
                detail = e.getCause().getMessage();
            }
            throw new DatabaseException(e.getMessage(), detail, String.valueOf(e.getErrorCode()), e.getSQLState(), this.originalSql, null, ListUtil.asString(Array.fromList(this.getParameterValues()), ","), e);
        }
    }

    private ExecutedQuery respondWithCachedQuery(Attempt<Object> cachedQuery) {
        logger.debug("Query is present, returning cached result: {}", (Object)this.cacheKey);
        IStruct cacheMeta = Struct.of(new Object[]{"cached", true, "cacheKey", this.cacheKey, "cacheProvider", this.cacheProvider.getName().toString(), "cacheTimeout", this.queryOptions.cacheTimeout, "cacheLastAccessTimeout", this.queryOptions.cacheLastAccessTimeout});
        return ExecutedQuery.fromCachedQuery((ExecutedQuery)cachedQuery.get(), cacheMeta);
    }

    private void applyParameters(Statement statement) throws SQLException {
        if (this.parameters.isEmpty()) {
            return;
        }
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            for (int i = 1; i <= this.parameters.size(); ++i) {
                QueryParameter param = this.parameters.get(i - 1);
                Integer scaleOrLength = param.getScaleOrLength();
                if (scaleOrLength == null) {
                    preparedStatement.setObject(i, param.toSQLType(), param.getSqlTypeAsInt());
                    continue;
                }
                preparedStatement.setObject(i, param.toSQLType(), param.getSqlTypeAsInt(), (int)scaleOrLength);
            }
        }
    }

    private void applyStatementOptions(Statement statement) throws SQLException {
        Integer fetchSize;
        Integer maxRows;
        Integer queryTimeout;
        IStruct options = this.queryOptions.toStruct();
        if (options.containsKey(Key.queryTimeout) && (queryTimeout = (Integer)options.getOrDefault(Key.queryTimeout, (Object)0)) > 0) {
            statement.setQueryTimeout(queryTimeout);
        }
        if (options.containsKey(Key.maxRows) && (maxRows = (Integer)options.getOrDefault(Key.maxRows, (Object)0)) > 0) {
            statement.setLargeMaxRows(maxRows.intValue());
        }
        if (options.containsKey(Key.fetchSize) && (fetchSize = (Integer)options.getOrDefault(Key.fetchSize, (Object)0)) > 0) {
            statement.setFetchSize(fetchSize);
        }
    }

    private boolean isCacheable() {
        return Boolean.TRUE.equals(this.queryOptions.cache);
    }
}

