/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.time.Duration;
import javax.annotation.Nullable;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.jdbc.ExecutedQuery;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class QueryOptions {
    private IStruct options;
    public final Object datasource;
    @Nullable
    public final String resultVariableName;
    private String returnType;
    private String columnKey;
    public final String username;
    public final String password;
    public final Integer queryTimeout;
    public final Long maxRows;
    public final Integer fetchSize;
    public final Boolean cache;
    public final String cacheKey;
    public final String cacheProvider;
    public final Duration cacheTimeout;
    public final Duration cacheLastAccessTimeout;

    public QueryOptions(IStruct options) {
        CacheService cacheService = BoxRuntime.getInstance().getCacheService();
        this.options = options;
        this.resultVariableName = options.getAsString(Key.result);
        this.username = options.getAsString(Key.username);
        this.password = options.getAsString(Key.password);
        this.queryTimeout = options.getAsInteger(Key.timeout);
        this.datasource = options.get(Key.datasource);
        this.fetchSize = (Integer)options.getOrDefault(Key.fetchSize, (Object)0);
        this.cache = BooleanCaster.attempt(options.get(Key.cache)).getOrDefault(false);
        this.cacheKey = options.getAsString(Key.cacheKey);
        this.cacheTimeout = (Duration)options.getOrDefault(Key.cacheTimeout, (Object)Duration.ZERO);
        this.cacheLastAccessTimeout = (Duration)options.getOrDefault(Key.cacheLastAccessTimeout, (Object)Duration.ZERO);
        this.cacheProvider = (String)options.getOrDefault(Key.cacheProvider, (Object)cacheService.getDefaultCache().getName().toString());
        Integer intMaxRows = options.getAsInteger(Key.maxRows);
        this.maxRows = intMaxRows != null ? (long)intMaxRows.intValue() : -1L;
        this.determineReturnType();
    }

    public boolean wantsResultStruct() {
        return this.resultVariableName != null;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Object castAsReturnType(ExecutedQuery query) {
        return switch (this.returnType) {
            case "query" -> query.getResults();
            case "array" -> query.getResultsAsArray();
            case "struct" -> query.getResultsAsStruct(this.columnKey);
            default -> throw new BoxRuntimeException("Unknown return type: " + this.returnType);
        };
    }

    public boolean wantsUsernameAndPassword() {
        return this.username != null;
    }

    private void determineReturnType() {
        String returnTypeString;
        Object returnTypeObject = this.options.get(Key.returnType);
        CastAttempt<String> returnTypeAsString = StringCaster.attempt(returnTypeObject);
        switch (returnTypeString = returnTypeAsString.getOrDefault("query")) {
            case "query": 
            case "array": {
                this.returnType = returnTypeString;
                break;
            }
            case "struct": {
                this.columnKey = this.options.getAsString(Key.columnKey);
                if (this.columnKey == null) {
                    throw new BoxRuntimeException("You must define a `columnKey` option when using `returnType: struct`.");
                }
                this.returnType = "struct";
                break;
            }
            default: {
                throw new BoxRuntimeException("Unknown return type: " + returnTypeString);
            }
        }
    }

    public IStruct toStruct() {
        Struct result = new Struct(this.options);
        result.put("fetchSize", (Object)this.fetchSize);
        result.put("setQueryTimeout", (Object)this.queryTimeout);
        result.put("setMaxRows", (Object)this.maxRows);
        return result;
    }
}

