/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.sql.Timestamp;
import ortus.boxlang.runtime.dynamic.casters.BigIntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.ListUtil;

public class QueryParameter {
    private final Object value;
    private final QueryColumnType type;
    private final Integer maxLength;
    private final Integer scale;
    private final boolean isNullParam;
    private final boolean isListParam;

    private QueryParameter(IStruct param) {
        String sqltype = (String)param.getOrDefault(Key.sqltype, (Object)"VARCHAR");
        this.isNullParam = Boolean.TRUE.equals(param.getOrDefault(Key.nulls, (Object)false));
        this.isListParam = Boolean.TRUE.equals(param.getOrDefault(Key.list, (Object)false));
        Object v = param.get(Key.value);
        if (this.isListParam) {
            v = ListUtil.asList((String)v, (String)param.getOrDefault(Key.separator, (Object)","));
            sqltype = "ARRAY";
        }
        this.value = this.isNullParam ? null : v;
        this.type = QueryColumnType.fromString(sqltype.replaceAll("(?i)CF_SQL_", ""));
        this.maxLength = param.getAsInteger(Key.maxLength);
        this.scale = param.getAsInteger(Key.scale);
    }

    public static QueryParameter fromAny(Object value) {
        CastAttempt<IStruct> castAsStruct = StructCaster.attempt(value);
        if (castAsStruct.wasSuccessful()) {
            return new QueryParameter((IStruct)castAsStruct.getOrFail());
        }
        return new QueryParameter(Struct.of(new Object[]{"value", value}));
    }

    public Object getValue() {
        return this.value;
    }

    public Object toSQLType() {
        if (this.value == null) {
            return null;
        }
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case QueryColumnType.INTEGER -> IntegerCaster.cast(this.value);
            case QueryColumnType.BIGINT -> BigIntegerCaster.cast(this.value);
            case QueryColumnType.DOUBLE -> DoubleCaster.cast(this.value);
            case QueryColumnType.DECIMAL -> DoubleCaster.cast(this.value);
            case QueryColumnType.CHAR, QueryColumnType.VARCHAR -> StringCaster.cast(this.value);
            case QueryColumnType.BINARY -> this.value;
            case QueryColumnType.BIT -> BooleanCaster.cast(this.value);
            case QueryColumnType.TIME -> DateTimeCaster.cast(this.value);
            case QueryColumnType.DATE -> DateTimeCaster.cast(this.value);
            case QueryColumnType.TIMESTAMP -> new Timestamp(DateTimeCaster.cast(this.value).toEpochMillis());
            case QueryColumnType.OBJECT -> this.value;
            case QueryColumnType.OTHER -> this.value;
            case QueryColumnType.NULL -> null;
        };
    }

    public int getSqlTypeAsInt() {
        return this.type.sqlType;
    }

    public Integer getScaleOrLength() {
        return switch (this.type) {
            case QueryColumnType.DOUBLE, QueryColumnType.DECIMAL -> this.scale;
            default -> this.maxLength;
        };
    }

    public boolean isNull() {
        return this.isNullParam;
    }
}

