/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.jdbc.DataSource;
import ortus.boxlang.runtime.jdbc.ITransaction;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;

public class Transaction
implements ITransaction {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private Connection connection;
    private DataSource datasource;
    private Integer isolationLevel = null;
    private Integer originalIsolationLevel = null;
    private Map<Key, Savepoint> savepoints = new HashMap<Key, Savepoint>();

    public Transaction(DataSource datasource) {
        this.datasource = datasource;
    }

    @Override
    public Transaction setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    @Override
    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.datasource.getConnection();
            try {
                this.connection.setAutoCommit(false);
                if (this.isolationLevel != null) {
                    this.originalIsolationLevel = this.connection.getTransactionIsolation();
                    this.connection.setTransactionIsolation(this.isolationLevel);
                }
                IStruct eventData = Struct.of(new Object[]{"transaction", this, "connection", this.connection});
                BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_ACQUIRE, eventData);
            }
            catch (SQLException e) {
                throw new DatabaseException("Failed to begin transaction:", e);
            }
        }
        return this.connection;
    }

    @Override
    public Transaction setDataSource(DataSource datasource) {
        if (this.datasource != null) {
            throw new DatabaseException("Transaction datasource is already configured");
        }
        this.datasource = datasource;
        return this;
    }

    @Override
    public DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public Transaction begin() {
        IStruct eventData = Struct.of(new Object[]{"transaction", this});
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_BEGIN, eventData);
        return this;
    }

    @Override
    public Transaction commit() {
        IStruct eventData = Struct.of(new Object[]{"connection", this.connection == null ? null : this.connection, "transaction", this});
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_COMMIT, eventData);
        if (this.connection != null) {
            try {
                logger.debug("Committing transaction");
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new DatabaseException("Failed to commit transaction: " + e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public Transaction rollback() {
        return this.rollback(Key.nulls);
    }

    @Override
    public Transaction rollback(Key savepoint) {
        IStruct eventData = Struct.of(new Object[]{"savepoint", savepoint == null ? null : savepoint.toString(), "connection", this.connection == null ? null : this.connection, "transaction", this});
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_ROLLBACK, eventData);
        if (this.connection != null) {
            try {
                if (savepoint != null && savepoint != Key.nulls) {
                    if (!this.savepoints.containsKey(savepoint)) {
                        throw new DatabaseException("Savepoint not found: " + savepoint.toString());
                    }
                    logger.debug("Rolling back transaction to savepoint: {}", (Object)savepoint);
                    this.connection.rollback(this.savepoints.get(savepoint));
                } else {
                    logger.debug("Rolling back transaction, no savepoint defined");
                    this.connection.rollback();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException("Failed to rollback transaction:" + e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public Transaction setSavepoint(Key savepoint) {
        if (savepoint == null) {
            throw new DatabaseException("Savepoint name cannot be null");
        }
        IStruct eventData = Struct.of(new Object[]{"savepoint", savepoint == null ? null : savepoint.toString(), "connection", this.connection == null ? null : this.connection, "transaction", this});
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_SET_SAVEPOINT, eventData);
        if (this.connection != null) {
            try {
                logger.debug("Setting transaction savepoint: {}", (Object)savepoint.getNameNoCase());
                this.savepoints.put(savepoint, this.connection.setSavepoint(savepoint.getNameNoCase()));
            }
            catch (SQLException e) {
                throw new DatabaseException("Failed to set savepoint: " + e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public Transaction end() {
        IStruct eventData = Struct.of(new Object[]{"connection", this.connection == null ? null : this.connection, "transaction", this});
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_END, eventData);
        if (this.connection != null) {
            try {
                logger.debug("Ending transaction, resetting connection properties, and releasing connection to connection pool");
                IStruct releaseEventData = Struct.of(new Object[]{"transaction", this, "connection", this.connection});
                BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_TRANSACTION_RELEASE, releaseEventData);
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(true);
                }
                if (this.isolationLevel != null) {
                    this.connection.setTransactionIsolation(this.originalIsolationLevel);
                }
                this.connection.close();
            }
            catch (SQLException e) {
                throw new DatabaseException("Error closing connection: " + e.getMessage(), e);
            }
        }
        return this;
    }
}

