/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc.drivers;

import java.util.Arrays;
import ortus.boxlang.runtime.scopes.Key;

public enum DatabaseDriverType {
    DB2(Key.of("db2")),
    DERBY(Key.of("Derby")),
    DERBYMEMORY(Key.of("DerbyMemory")),
    GENERIC(Key.of("Generic")),
    HYPERSONIC(Key.of("Hypersonic")),
    MARIADB(Key.of("MariaDB")),
    MSSQL(Key.of("MSSQL")),
    MYSQL(Key.of("MySQL")),
    ORACLE(Key.of("Oracle")),
    OTHER(Key.of("Other")),
    POSTGRESSQL(Key.of("PostgreSQL")),
    SQLITE(Key.of("sqlite")),
    SYBASE(Key.of("sybase"));

    private Key key;

    private DatabaseDriverType(Key key) {
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    public static DatabaseDriverType fromKey(Key key) {
        for (DatabaseDriverType type : DatabaseDriverType.values()) {
            if (!type.key.equals(key)) continue;
            return type;
        }
        return GENERIC;
    }

    public static DatabaseDriverType fromKey(String key) {
        return DatabaseDriverType.fromKey(Key.of(key));
    }

    public static boolean isValid(Key key) {
        for (DatabaseDriverType type : DatabaseDriverType.values()) {
            if (!type.key.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(String key) {
        return DatabaseDriverType.isValid(Key.of(key));
    }

    public static Key[] toArray() {
        return (Key[])Arrays.stream(DatabaseDriverType.values()).map(val -> val.key).sorted().toArray(Key[]::new);
    }

    public String toString() {
        return this.key.getName();
    }
}

