/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc.drivers;

import ortus.boxlang.runtime.config.segments.DatasourceConfig;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.jdbc.drivers.DatabaseDriverType;
import ortus.boxlang.runtime.jdbc.drivers.IJDBCDriver;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.StructUtil;

public class GenericJDBCDriver
implements IJDBCDriver {
    protected Key name;
    protected DatabaseDriverType type;
    protected String driverClassName = "";
    protected String defaultDelimiter = "&";
    protected String defaultPort;
    protected String defaultHost = "localhost";
    protected IStruct defaultCustomParams = Struct.of(new Object[0]);
    protected IStruct defaultProperties = Struct.of(new Object[0]);

    public GenericJDBCDriver() {
        this.name = new Key("Generic");
        this.type = DatabaseDriverType.GENERIC;
    }

    @Override
    public Key getName() {
        return this.name;
    }

    @Override
    public DatabaseDriverType getType() {
        return this.type;
    }

    @Override
    public String getClassName() {
        return this.driverClassName;
    }

    @Override
    public String buildConnectionURL(DatasourceConfig config) {
        String jDriver = (String)config.properties.getOrDefault(Key.driver, (Object)"");
        if (jDriver.isEmpty()) {
            throw new IllegalArgumentException("The driver property is required for the Generic JDBC Driver");
        }
        Integer port = IntegerCaster.cast(config.properties.getOrDefault(Key.port, (Object)0), false);
        if (port == null || port == 0) {
            throw new IllegalArgumentException("The port property is required for the Generic JDBC Driver");
        }
        String database = (String)config.properties.getOrDefault(Key.database, (Object)"");
        String host = (String)config.properties.getOrDefault(Key.host, (Object)"localhost");
        return String.format("jdbc:%s://%s:%d/%s?%s", jDriver, host, port, database, this.customParamsToQueryString(config));
    }

    @Override
    public IStruct getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public IStruct getDefaultCustomParams() {
        return this.defaultCustomParams;
    }

    public String getDefaultPort() {
        return this.defaultPort;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public String getDefaultDelimiter() {
        return this.defaultDelimiter;
    }

    public String customParamsToQueryString(DatasourceConfig config) {
        Struct params = new Struct(this.defaultCustomParams);
        Object v = config.properties.get(Key.custom);
        if (v instanceof String) {
            String castedParams = (String)v;
            config.properties.put(Key.custom, (Object)StructUtil.fromQueryString(castedParams, this.defaultDelimiter));
        }
        config.properties.getAsStruct(Key.custom).forEach(params::put);
        return StructUtil.toQueryString(params, this.defaultDelimiter);
    }
}

