/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.loader.resolvers.BoxResolver;
import ortus.boxlang.runtime.loader.resolvers.IClassResolver;
import ortus.boxlang.runtime.loader.resolvers.JavaResolver;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ClassNotFoundBoxLangException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;

public class ClassLocator
extends ClassLoader {
    public static final int TYPE_BX = 1;
    public static final int TYPE_JAVA = 2;
    public static final String BX_PREFIX = "bx";
    public static final String JAVA_PREFIX = "java";
    public static final String DEFAULT_RESOLVER = "bx";
    private static ClassLocator instance;
    private ConcurrentMap<String, ClassLocation> resolverCache = new ConcurrentHashMap<String, ClassLocation>();
    private ConcurrentHashMap<String, IClassResolver> resolvers = new ConcurrentHashMap();
    private static final List<String> RESERVED_RESOLVERS;
    private BoxRuntime runtime;

    private ClassLocator() {
        super(ClassLocator.getSystemClassLoader());
    }

    public static synchronized ClassLocator getInstance() {
        if (instance == null) {
            throw new BoxRuntimeException("The ClassLocator instance has not been initialized.");
        }
        return instance;
    }

    public static synchronized ClassLocator getInstance(BoxRuntime runtime) {
        if (instance == null) {
            instance = new ClassLocator();
            ClassLocator.instance.runtime = runtime;
            instance.registerResolver(new BoxResolver(instance));
            instance.registerResolver(new JavaResolver(instance));
        }
        return instance;
    }

    public BoxRuntime getRuntime() {
        return this.runtime;
    }

    public JavaResolver getJavaResolver() {
        return (JavaResolver)this.getResolver(JAVA_PREFIX);
    }

    public BoxResolver getBoxResolver() {
        return (BoxResolver)this.getResolver("bx");
    }

    public ConcurrentMap<String, ClassLocation> getResolverCache() {
        return this.resolverCache;
    }

    public void registerResolver(IClassResolver resolver) {
        if (this.hasResolver(resolver.getPrefix()).booleanValue()) {
            throw new BoxRuntimeException(String.format("The resolver [%s] is already registered", resolver.getPrefix()));
        }
        this.resolvers.put(resolver.getPrefix(), resolver);
    }

    public List<String> getResolvedPrefixes() {
        return this.resolvers.keySet().stream().toList();
    }

    public IClassResolver getResolver(String prefix) {
        IClassResolver target = this.resolvers.get(prefix.toLowerCase());
        if (target == null) {
            throw new KeyNotFoundException(String.format("The resolver [%s] was not found in the registered resolvers. Valid resolvers are [%s]", prefix, this.getResolvedPrefixes()));
        }
        return target;
    }

    public Boolean hasResolver(String prefix) {
        return this.resolvers.containsKey(prefix.toLowerCase());
    }

    public Boolean removeResolver(String prefix) {
        if (RESERVED_RESOLVERS.contains(prefix = prefix.toLowerCase())) {
            throw new BoxRuntimeException(String.format("The resolver [%s] is reserved and cannot be removed", prefix));
        }
        return this.resolvers.remove(prefix) != null;
    }

    public Boolean isEmpty() {
        return this.resolverCache.isEmpty();
    }

    public int size() {
        return this.resolverCache.size();
    }

    public ClassLocator clear() {
        this.resolverCache.clear();
        return instance;
    }

    public Boolean clear(String name) {
        return this.resolverCache.remove(name) != null;
    }

    private Optional<ClassLocation> getClass(String name) {
        return Optional.ofNullable((ClassLocation)this.resolverCache.get(name));
    }

    public boolean hasClass(String name) {
        return this.resolverCache.containsKey(name);
    }

    public Set<String> classSet() {
        return this.resolverCache.keySet();
    }

    public DynamicObject load(IBoxContext context, String name) {
        return this.load(context, name, List.of());
    }

    public DynamicObject load(IBoxContext context, String name, List<ImportDefinition> imports) {
        int resolverDelimiterPos = name.indexOf(":");
        if (resolverDelimiterPos == -1) {
            ClassLocation target = this.resolveFromSystem(context, name, true, imports);
            return target == null ? null : DynamicObject.of(target.clazz(), context);
        }
        String resolverPrefix = name.substring(0, resolverDelimiterPos);
        String className = name.substring(resolverDelimiterPos + 1);
        return this.load(context, className, resolverPrefix, true, imports);
    }

    public DynamicObject load(IBoxContext context, String name, String resolverPrefix) {
        return this.load(context, name, resolverPrefix, true);
    }

    public DynamicObject load(IBoxContext context, String name, String resolverPrefix, Boolean throwException) {
        return this.load(context, name, resolverPrefix, throwException, List.of());
    }

    public DynamicObject load(IBoxContext context, String name, String resolverPrefix, Boolean throwException, List<ImportDefinition> imports) {
        if (imports == null) {
            imports = List.of();
        }
        List<ImportDefinition> thisImports = imports;
        String cacheKey = resolverPrefix + ":" + name;
        Optional<ClassLocation> resolvedClass = this.getClass(cacheKey).or(() -> this.getResolver(resolverPrefix).resolve(context, name, thisImports)).map(target -> {
            if (target.cachable().booleanValue()) {
                this.resolverCache.put(cacheKey, (ClassLocation)target);
            }
            return target;
        });
        if (resolvedClass.isPresent()) {
            return DynamicObject.of(resolvedClass.get().clazz(), context);
        }
        if (throwException.booleanValue()) {
            throw new ClassNotFoundBoxLangException(String.format("The requested class [%s] has not been located in the [%s] resolver.", name, resolverPrefix));
        }
        return null;
    }

    public Optional<DynamicObject> safeLoad(IBoxContext context, String name) {
        return this.safeLoad(context, name, List.of());
    }

    public Optional<DynamicObject> safeLoad(IBoxContext context, String name, List<ImportDefinition> imports) {
        ClassLocation location = this.resolveFromSystem(context, name, false, imports);
        return location == null ? Optional.empty() : Optional.of(DynamicObject.of(location.clazz(), context));
    }

    public Optional<DynamicObject> safeLoad(IBoxContext context, String name, String resolverPrefix) {
        return this.safeLoad(context, name, resolverPrefix, List.of());
    }

    public Optional<DynamicObject> safeLoad(IBoxContext context, String name, String resolverPrefix, List<ImportDefinition> imports) {
        DynamicObject target = this.load(context, name, resolverPrefix, false, imports);
        return target == null ? Optional.empty() : Optional.of(target);
    }

    public Class<?> findClass(IBoxContext context, String name, List<ImportDefinition> imports) {
        ClassLocation target = this.resolveFromSystem(context, name, true, imports);
        try {
            return target == null ? super.findClass(name) : target.clazz();
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundBoxLangException(String.format("The requested class [%s] was not found.", name));
        }
    }

    private ClassLocation resolveFromSystem(IBoxContext context, String name, Boolean throwException, List<ImportDefinition> imports) {
        Optional<ClassLocation> resolvedClass = this.getClass(name).or(() -> this.getResolver("bx").resolve(context, name, imports)).or(() -> this.getResolver(JAVA_PREFIX).resolve(context, name, imports)).map(target -> {
            if (target.cachable().booleanValue()) {
                this.resolverCache.put(name, (ClassLocation)target);
            }
            return target;
        });
        if (resolvedClass.isPresent()) {
            return resolvedClass.get();
        }
        if (throwException.booleanValue()) {
            throw new ClassNotFoundBoxLangException(String.format("The requested class [%s] has not been located in any class resolver.", name));
        }
        return null;
    }

    static {
        RESERVED_RESOLVERS = List.of("bx", JAVA_PREFIX);
    }

    public record ClassLocation(String name, String path, String packageName, int type, Class<?> clazz, String module, Boolean cachable) {
        Boolean isFromModule() {
            return this.module != null;
        }

        @Override
        public String toString() {
            return String.format("ClassLocation [name=%s, path=%s, packageName=%s, type=%s, clazz=%s, module=%s, cachable=%s]", this.name, this.path, this.packageName, this.type, this.clazz, this.module, this.cachable);
        }
    }
}

