/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.runtime.BoxRuntime;

public class DiskClassLoader
extends URLClassLoader {
    private Path diskStore;
    IBoxpiler boxPiler;
    String classPoolName;
    String classPoolDiskPrefix;

    public DiskClassLoader(URL[] urls, ClassLoader parent, Path diskStore, IBoxpiler boxpiler, String classPoolName) {
        super(urls, parent);
        this.boxPiler = boxpiler;
        this.classPoolName = classPoolName;
        this.classPoolDiskPrefix = classPoolName.replaceAll("[^a-zA-Z0-9]", "_");
        this.diskStore = diskStore.resolve(this.classPoolDiskPrefix);
        diskStore.toFile().mkdirs();
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        Path diskPath = this.generateDiskPath(name);
        String baseName = IBoxpiler.getBaseFQN(name);
        ClassInfo classInfo = this.boxPiler.getClassPool(this.classPoolName).get(baseName);
        if (this.needsCompile(classInfo, diskPath, name, baseName)) {
            this.boxPiler.compileClassInfo(this.classPoolName, baseName);
        }
        if (!diskPath.toFile().exists()) {
            return this.loadClass(name);
        }
        try {
            bytes = Files.readAllBytes(diskPath);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Unable to read class file from disk", e);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    private boolean needsCompile(ClassInfo classInfo, Path diskPath, String name, String baseName) {
        if (!name.equals(baseName)) {
            return false;
        }
        if (this.hasClass(diskPath)) {
            return classInfo != null && classInfo.lastModified() > diskPath.toFile().lastModified();
        }
        return true;
    }

    public boolean hasClass(String name) {
        if (BoxRuntime.getInstance().inDebugMode().booleanValue()) {
            return false;
        }
        return this.generateDiskPath(name).toFile().exists();
    }

    public boolean hasClass(String name, long lastModified) {
        Path diskPath = this.generateDiskPath(name);
        if (!diskPath.toFile().exists()) {
            return false;
        }
        return lastModified <= diskPath.toFile().lastModified();
    }

    private boolean hasClass(Path name) {
        return name.toFile().exists();
    }

    private Path generateDiskPath(String name) {
        return Paths.get(this.diskStore.toString(), name.replace(".", File.separator) + ".class");
    }

    private void appendToClassPathForInstrumentation(String jarfile) throws IOException {
        this.addURL(Paths.get(jarfile, new String[0]).toRealPath(new LinkOption[0]).toUri().toURL());
    }

    public void defineClasses(String fqn, File sourceFile) {
        try {
            byte[] fileBytes = Files.readAllBytes(sourceFile.toPath());
            ByteBuffer buffer = ByteBuffer.wrap(fileBytes);
            buffer.getInt();
            boolean first = true;
            while (buffer.hasRemaining()) {
                int length = buffer.getInt();
                byte[] classBytes = new byte[length];
                buffer.get(classBytes);
                if (first) {
                    first = false;
                    String classNameInFile = new String(classBytes);
                    if (fqn.equals(classNameInFile)) continue;
                    throw new RuntimeException("The source file " + sourceFile.toPath().toString() + " is pre-compiled bytecode, but its original class name [" + classNameInFile + "] does not match what we expected [" + fqn + "].  Pre-compiled source code must have the same path and name as the original file.");
                }
                this.defineClass(null, classBytes, 0, classBytes.length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file", e);
        }
    }

    public static String getClassName(byte[] classBytes) {
        ClassReader classReader = new ClassReader(classBytes);
        ClassNode classNode = new ClassNode();
        classReader.accept(classNode, 0);
        return classNode.name.replace('/', '.');
    }
}

