/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.bifs.global.type.NullValue;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class DynamicClassLoader
extends URLClassLoader {
    private Key nameAsKey;
    private ClassLoader parent = null;
    private boolean closed = false;
    private String closedStack = "";
    private final ConcurrentHashMap<String, Class<?>> loadedClasses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> unfoundClasses = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(DynamicClassLoader.class);

    public DynamicClassLoader(Key name, URL url, ClassLoader parent, Boolean loadParentFirst) {
        this(name, new URL[]{url}, parent, loadParentFirst);
    }

    public DynamicClassLoader(Key name, URL[] urls, ClassLoader parent, Boolean loadParentFirst) {
        super(name.getName(), urls, loadParentFirst != false ? parent : null);
        Objects.requireNonNull(parent, "Parent class loader cannot be null");
        this.parent = parent;
        this.nameAsKey = name;
    }

    public DynamicClassLoader(Key name, ClassLoader parent) {
        this(name, new URL[0], parent, (Boolean)false);
    }

    public Key getNameAsKey() {
        return this.nameAsKey;
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false);
    }

    public Class<?> findClass(String className, Boolean safe) throws ClassNotFoundException {
        if (this.closed) {
            throw new BoxRuntimeException("Class loader [" + this.nameAsKey.getName() + "] is closed, but you are trying to use it still! Closed by this thread: \n\n" + this.closedStack);
        }
        if (safe == null) {
            safe = false;
        }
        logger.trace("[{}] Discovering class: [{}]", (Object)this.nameAsKey.getName(), (Object)className);
        Class<?> cachedClass = this.loadedClasses.get(className);
        if (cachedClass != null) {
            logger.trace("[{}].[{}] : Class found in cache", (Object)this.nameAsKey.getName(), (Object)className);
            return cachedClass;
        }
        if (this.unfoundClasses.containsKey(className)) {
            logger.trace("[{}].[{}] : Class not found in cache, but already in unfound cache", (Object)this.nameAsKey.getName(), (Object)className);
            if (safe.booleanValue()) {
                return null;
            }
            throw new ClassNotFoundException(String.format("Class [%s] not found in class loader [%s]", className, this.nameAsKey.getName()));
        }
        try {
            cachedClass = super.findClass(className);
            logger.trace("[{}].[{}] : Class found locally", (Object)this.nameAsKey.getName(), (Object)className);
        }
        catch (ClassNotFoundException e) {
            try {
                logger.trace("[{}].[{}] : Class not found locally, trying the parent...", (Object)this.nameAsKey.getName(), (Object)className);
                cachedClass = this.getDynamicParent().loadClass(className);
                logger.trace("[{}].[{}] : Class found in parent", (Object)this.nameAsKey.getName(), (Object)className);
            }
            catch (ClassNotFoundException parentException) {
                this.unfoundClasses.put(className, NullValue.class);
                if (!safe.booleanValue()) {
                    throw new ClassNotFoundException(String.format("Class [%s] not found in class loader [%s]", className, this.nameAsKey.getName()));
                }
                logger.trace("[{}].[{}] : Class not found in parent", (Object)this.nameAsKey.getName(), (Object)className);
            }
        }
        if (cachedClass != null) {
            this.loadedClasses.put(className, cachedClass);
        }
        return cachedClass;
    }

    public ClassLoader getDynamicParent() {
        return this.parent;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addURLs(URL[] urls) {
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    public void clearCache() {
        this.loadedClasses.clear();
    }

    public boolean isCacheEmpty() {
        return this.loadedClasses.isEmpty();
    }

    public boolean isClassInCache(String className) {
        return this.loadedClasses.containsKey(className);
    }

    public Set<String> getCacheKeys() {
        return this.loadedClasses.keySet();
    }

    public int getCacheSize() {
        return this.loadedClasses.size();
    }

    public Map<String, Class<?>> getUnfoundClasses() {
        return this.unfoundClasses;
    }

    public Set<String> getUnfoundClassesKeys() {
        return this.unfoundClasses.keySet();
    }

    public int getUnfoundClassesSize() {
        return this.unfoundClasses.size();
    }

    public void clearUnfoundClasses() {
        this.unfoundClasses.clear();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Exception().printStackTrace(pw);
        this.closedStack = sw.toString();
        this.clearCache();
        this.parent = null;
        super.close();
    }

    public static URL[] getJarURLs(String targetPath) throws IOException {
        return DynamicClassLoader.getJarURLs(Paths.get(targetPath, new String[0]));
    }

    public static URL[] getJarURLs(Path targetPath) throws IOException {
        if (Files.exists(targetPath, new LinkOption[0]) && !Files.isDirectory(targetPath, new LinkOption[0])) {
            throw new BoxRuntimeException(String.format("The requested path [%s] to discover jar's and classes must be a valid directory", targetPath));
        }
        try (Stream<Path> fileStream = Files.walk(targetPath, new FileVisitOption[0]);){
            URL[] uRLArray = (URL[])((Stream)fileStream.parallel()).filter(path -> path.toString().endsWith(".jar") || path.toString().endsWith(".class")).map(path -> {
                try {
                    return path.toUri().toURL();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new);
            return uRLArray;
        }
    }

    public static URL[] inflateClassPaths(Array paths) {
        return (URL[])paths.stream().map(path -> {
            try {
                Path targetPath = Paths.get((String)path, new String[0]);
                if (Files.isDirectory(targetPath, new LinkOption[0])) {
                    return DynamicClassLoader.getJarURLs(targetPath);
                }
                return new URL[]{targetPath.toUri().toURL()};
            }
            catch (IOException e) {
                throw new BoxIOException(String.valueOf(path) + " is not a valid path", e);
            }
        }).flatMap(Arrays::stream).distinct().toArray(URL[]::new);
    }
}

