/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader;

import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public record ImportDefinition(String className, String resolverPrefix, String alias, String moduleName) {
    public ImportDefinition {
        if (className == null) {
            throw new BoxRuntimeException("Class name cannot be null.");
        }
    }

    public Boolean isMultiImport() {
        return this.className.endsWith(".*");
    }

    public Boolean isModuleImport() {
        return this.moduleName != null;
    }

    public String getPackageName() {
        return this.className.substring(0, this.className.lastIndexOf("."));
    }

    public String getFullyQualifiedClass(String targetClass) {
        if (this.isMultiImport().booleanValue()) {
            return String.format("%s.%s", this.className.substring(0, this.className.length() - 2), targetClass);
        }
        if (this.isModuleImport().booleanValue()) {
            return String.format("%s@%s", this.className, this.moduleName);
        }
        return this.className;
    }

    public static ImportDefinition parse(String importStr) {
        int resolverDelimiterPos;
        String className = importStr;
        String resolverPrefix = null;
        String alias = null;
        String module = null;
        int aliasDelimiterPos = importStr.toLowerCase().lastIndexOf(" as ");
        if (aliasDelimiterPos != -1) {
            alias = importStr.substring(aliasDelimiterPos + 4);
            className = importStr.substring(0, aliasDelimiterPos);
        } else {
            int moduleDelimiterPos;
            String[] parts2 = className.split("\\.");
            alias = parts2[parts2.length - 1];
            if (alias.contains("$")) {
                alias = alias.substring(alias.lastIndexOf("$") + 1);
            }
            if ((moduleDelimiterPos = alias.indexOf("@")) != -1) {
                alias = alias.substring(0, moduleDelimiterPos);
            }
        }
        int moduleDelimiterPos = className.indexOf("@");
        if (moduleDelimiterPos != -1) {
            module = className.substring(moduleDelimiterPos + 1);
            className = className.substring(0, moduleDelimiterPos);
        }
        if ((resolverDelimiterPos = className.indexOf(":")) != -1) {
            resolverPrefix = className.substring(0, resolverDelimiterPos);
            className = className.substring(resolverDelimiterPos + 1);
        }
        return new ImportDefinition(className, resolverPrefix, alias, module);
    }
}

