/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader.resolvers;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ClassUtils;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.Configuration;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.loader.resolvers.IClassResolver;
import ortus.boxlang.runtime.loader.util.ClassDiscovery;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class BaseResolver
implements IClassResolver {
    protected String name = "";
    protected String prefix = "";
    protected BoxRuntime runtime;
    protected ClassLocator classLocator;
    protected Set<String> importCache = ConcurrentHashMap.newKeySet();

    protected BaseResolver(String name, String prefix, ClassLocator classLocator) {
        this.name = name;
        this.prefix = prefix.toLowerCase();
        this.classLocator = classLocator;
        this.runtime = classLocator.getRuntime();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public Set<String> getImportCache() {
        return this.importCache;
    }

    public Integer getImportCacheSize() {
        return this.importCache.size();
    }

    public void clearImportCache() {
        this.importCache.clear();
    }

    public BoxRuntime getRuntime() {
        return this.runtime;
    }

    public ClassLocator getClassLocator() {
        return this.classLocator;
    }

    public Configuration getConfiguration() {
        return this.getRuntime().getConfiguration();
    }

    @Override
    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name) {
        throw new BoxRuntimeException("Implement the [resolve] method in your own resolver");
    }

    @Override
    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name, List<ImportDefinition> imports) {
        throw new BoxRuntimeException("Implement the [resolve] method in your own resolver");
    }

    public String expandFromImport(IBoxContext context, String className, List<ImportDefinition> imports) {
        String fullyQualifiedName = imports.stream().filter(thisImport -> this.importApplies((ImportDefinition)thisImport) && this.importHas(context, (ImportDefinition)thisImport, className)).findFirst().map(targetImport -> {
            String fqn = targetImport.getFullyQualifiedClass(className);
            this.importCache.add(className + ":" + fqn);
            return fqn;
        }).orElse(className);
        BoxRuntime.getInstance().getConfiguration().security.isClassAllowed(fullyQualifiedName);
        return fullyQualifiedName;
    }

    protected boolean importHas(IBoxContext context, ImportDefinition thisImport, String className) {
        String cacheKey = className + ":" + thisImport.getFullyQualifiedClass(className);
        if (this.importCache.contains(cacheKey)) {
            return true;
        }
        return thisImport.isMultiImport() != false ? this.importHasMulti(context, thisImport, className) : thisImport.alias().equalsIgnoreCase(className);
    }

    protected boolean importHasMulti(IBoxContext context, ImportDefinition thisImport, String className) {
        try {
            return ClassDiscovery.getClassFilesAsStream(thisImport.getPackageName(), false).anyMatch(clazzName -> ClassUtils.getShortClassName(clazzName).equalsIgnoreCase(className));
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Could not discover classes in package [" + thisImport.getPackageName() + "]", e);
        }
    }

    protected boolean importApplies(ImportDefinition thisImport) {
        return thisImport.resolverPrefix() == null || thisImport.resolverPrefix().equalsIgnoreCase(this.prefix);
    }

    protected static DynamicClassLoader getSystemClassLoader() {
        return BoxRuntime.getInstance().getRuntimeLoader();
    }
}

