/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader.resolvers;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.loader.resolvers.BaseResolver;
import ortus.boxlang.runtime.modules.ModuleRecord;
import ortus.boxlang.runtime.runnables.RunnableLoader;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ModuleService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class BoxResolver
extends BaseResolver {
    private static final List<ImportDefinition> EMPTY_IMPORTS = List.of();

    public BoxResolver(ClassLocator classLocator) {
        super("BoxResolver", "bx", classLocator);
    }

    public Set<String> getValidExtensions() {
        return BoxRuntime.getInstance().getConfiguration().validClassExtensions;
    }

    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name, boolean loadClass) {
        return this.resolve(context, name, EMPTY_IMPORTS, loadClass);
    }

    @Override
    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name) {
        return this.resolve(context, name, EMPTY_IMPORTS, true);
    }

    @Override
    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name, List<ImportDefinition> imports) {
        return this.resolve(context, name, imports, true);
    }

    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name, List<ImportDefinition> imports, boolean loadClass) {
        name = (name = name.replace("../", "DOT_DOT_SLASH").replace("/", ".").replace("DOT_DOT_SLASH", "../").trim()).startsWith(".") && !name.startsWith("../") ? name.substring(1) : name;
        name = name.endsWith(".") ? name.substring(0, name.length() - 1) : name;
        String fullyQualifiedName = this.expandFromImport(context, name, imports);
        return this.findFromModules(context, fullyQualifiedName, imports, loadClass).or(() -> this.findFromLocal(context, fullyQualifiedName, imports, loadClass));
    }

    public Optional<ClassLocator.ClassLocation> findFromModules(IBoxContext context, String fullyQualifiedName, List<ImportDefinition> imports) {
        return this.findFromModules(context, fullyQualifiedName, imports, true);
    }

    public Optional<ClassLocator.ClassLocation> findFromModules(IBoxContext context, String fullyQualifiedName, List<ImportDefinition> imports, boolean loadClass) {
        String[] parts2 = fullyQualifiedName.split("@");
        if (parts2.length == 2) {
            return this.findFromModule(parts2[0], Key.of(parts2[1]), imports, context);
        }
        return Optional.ofNullable(null);
    }

    public Optional<ClassLocator.ClassLocation> findFromModule(String fullyQualifiedName, Key moduleName, List<ImportDefinition> imports, IBoxContext context) {
        ModuleService moduleService = BoxRuntime.getInstance().getModuleService();
        if (!moduleService.hasModule(moduleName)) {
            throw new BoxRuntimeException(String.format("Module requested [%s] not found when looking for [%s]. Valid modules are: [%s]", moduleName.getName(), fullyQualifiedName, moduleService.getModuleNames()));
        }
        ModuleRecord moduleRecord = moduleService.getModuleRecord(moduleName);
        String finalSlashName = this.getFullyQualifiedSlashName(fullyQualifiedName);
        Path targetPath = this.findExistingPathWithValidExtension(moduleRecord.physicalPath, finalSlashName);
        if (targetPath != null) {
            ResolvedFilePath resolvedFilePath = ResolvedFilePath.of(targetPath);
            return Optional.of(new ClassLocator.ClassLocation(resolvedFilePath.getBoxFQN().getClassName(), targetPath.toAbsolutePath().toString(), resolvedFilePath.getBoxFQN().getPackageString(), 1, RunnableLoader.getInstance().loadClass(resolvedFilePath, context), moduleName.getName(), false));
        }
        return Optional.empty();
    }

    public Optional<ClassLocator.ClassLocation> findFromLocal(IBoxContext context, String fullyQualifiedName, List<ImportDefinition> imports) {
        return this.findFromLocal(context, fullyQualifiedName, imports, true);
    }

    public Optional<ClassLocator.ClassLocation> findFromLocal(IBoxContext context, String fullyQualifiedName, List<ImportDefinition> imports, boolean loadClass) {
        String finalSlashName = this.getFullyQualifiedSlashName(fullyQualifiedName);
        return this.findByRelativeLocation(context, finalSlashName, this.name, imports, loadClass).or(() -> this.findByMapping(context, finalSlashName, this.name, imports, loadClass));
    }

    private Optional<ClassLocator.ClassLocation> findByMapping(IBoxContext context, String slashName, String name, List<ImportDefinition> imports, boolean loadClass) {
        IStruct mappings = context.getConfig().getAsStruct(Key.mappings);
        return mappings.entrySet().stream().filter(entry -> StringUtils.startsWithIgnoreCase(slashName, ((Key)entry.getKey()).getName())).flatMap(entry -> {
            ArrayList<ResolvedFilePath> paths = new ArrayList<ResolvedFilePath>();
            for (String extension : this.getValidExtensions()) {
                Path absolutePath = Path.of(StringUtils.replaceOnceIgnoreCase(slashName, ((Key)entry.getKey()).getName(), String.valueOf(entry.getValue()) + "/") + "." + extension, new String[0]).normalize();
                if ((absolutePath = FileSystemUtil.pathExistsCaseInsensitive(absolutePath)) == null) continue;
                try {
                    String mappingName = ((Key)entry.getKey()).getName();
                    String mappingDirectory = entry.getValue().toString();
                    String relativePath = mappingName.equals("/") || mappingName.equals("\\") ? Paths.get(mappingDirectory, new String[0]).toRealPath(new LinkOption[0]).relativize(absolutePath).toString() : Paths.get(mappingName, Paths.get(mappingDirectory, new String[0]).toRealPath(new LinkOption[0]).relativize(absolutePath).toString()).toString();
                    paths.add(ResolvedFilePath.of(mappingName, mappingDirectory, relativePath, absolutePath));
                }
                catch (IOException iOException) {}
            }
            return paths.stream();
        }).map(possibleMatch -> new ClassLocator.ClassLocation(possibleMatch.getBoxFQN().getClassName(), possibleMatch.absolutePath().toAbsolutePath().toString(), possibleMatch.getBoxFQN().getPackageString(), 1, loadClass ? RunnableLoader.getInstance().loadClass((ResolvedFilePath)possibleMatch, context) : null, "", false)).findFirst();
    }

    private Optional<ClassLocator.ClassLocation> findByRelativeLocation(IBoxContext context, String slashName, String name, List<ImportDefinition> imports, boolean loadClass) {
        Path targetPath;
        Path parentPath;
        Path template;
        ResolvedFilePath resolvedFilePath = context.findClosestTemplate();
        if (resolvedFilePath != null && (template = resolvedFilePath.absolutePath()) != null && !template.toString().equalsIgnoreCase("unknown") && (parentPath = template.getParent()) != null && (targetPath = this.findExistingPathWithValidExtension(parentPath, slashName)) != null) {
            ResolvedFilePath newResolvedFilePath = resolvedFilePath.newFromRelative(parentPath.relativize(Paths.get(targetPath.toString(), new String[0])).toString());
            return Optional.of(new ClassLocator.ClassLocation(newResolvedFilePath.getBoxFQN().getClassName(), targetPath.toAbsolutePath().toString(), newResolvedFilePath.getBoxFQN().getPackageString(), 1, loadClass ? RunnableLoader.getInstance().loadClass(newResolvedFilePath, context) : null, "", false));
        }
        return Optional.empty();
    }

    private Path findExistingPathWithValidExtension(Path parentPath, String slashName) {
        for (String extension : this.getValidExtensions()) {
            Path targetPath = parentPath.resolve(slashName.substring(1) + "." + extension).normalize();
            Path result = FileSystemUtil.pathExistsCaseInsensitive(targetPath);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String getFullyQualifiedSlashName(String fullyQualifiedName) {
        Object slashName = fullyQualifiedName.replace("../", "DOT_DOT_SLASH").replace(".", "/").replace("DOT_DOT_SLASH", "../");
        if (!((String)slashName).startsWith("/")) {
            slashName = "/" + (String)slashName;
        }
        return slashName;
    }

    @Override
    public boolean importHasMulti(IBoxContext context, ImportDefinition thisImport, String className) {
        String packageSlashName = this.getFullyQualifiedSlashName(thisImport.getPackageName());
        if (!FileSystemUtil.exists(packageSlashName).booleanValue()) {
            packageSlashName = FileSystemUtil.expandPath(context, packageSlashName).absolutePath().toString();
        }
        return FileSystemUtil.listDirectory(packageSlashName, false, null, "name", "file").anyMatch(path -> path.getFileName().toString().startsWith(className + "."));
    }
}

