/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.loader.resolvers;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.loader.resolvers.BaseResolver;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ModuleService;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class JavaResolver
extends BaseResolver {
    protected static JavaResolver instance;
    private Set<String> jdkClassImportCache = ConcurrentHashMap.newKeySet();
    private static final Logger logger;

    public JavaResolver(ClassLocator classLocator) {
        super("JavaResolver", "java", classLocator);
    }

    @Override
    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name) {
        return this.resolve(context, name, List.of());
    }

    @Override
    public Optional<ClassLocator.ClassLocation> resolve(IBoxContext context, String name, List<ImportDefinition> imports) {
        String fullyQualifiedName = this.expandFromImport(context, name, imports);
        return this.findFromModules(fullyQualifiedName, imports, context).or(() -> this.findFromSystem(fullyQualifiedName, imports, context));
    }

    public Optional<ClassLocator.ClassLocation> findFromModules(String fullyQualifiedName, List<ImportDefinition> imports, IBoxContext context) {
        String[] parts2 = fullyQualifiedName.split("@");
        if (parts2.length == 2) {
            return this.findFromModule(parts2[0], Key.of(parts2[1]), imports, context);
        }
        return this.findFromAllModules(fullyQualifiedName, imports, context);
    }

    public Optional<ClassLocator.ClassLocation> findFromAllModules(String fullyQualifiedName, List<ImportDefinition> imports, IBoxContext context) {
        return BoxRuntime.getInstance().getModuleService().getModuleNames().stream().map(moduleName -> this.findFromModule(fullyQualifiedName, (Key)moduleName, imports, context)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<ClassLocator.ClassLocation> findFromModule(String fullyQualifiedName, Key moduleName, List<ImportDefinition> imports, IBoxContext context) {
        ModuleService moduleService = BoxRuntime.getInstance().getModuleService();
        if (!moduleService.hasModule(moduleName)) {
            throw new BoxRuntimeException(String.format("Module requested [%s] not found when looking for [%s]. Valid modules are: [%s]", moduleName.getName(), fullyQualifiedName, moduleService.getModuleNames()));
        }
        Class<?> clazz = null;
        try {
            clazz = moduleService.getModuleRecord(moduleName).findModuleClass(fullyQualifiedName, true, context);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            return Optional.empty();
        }
        return Optional.of(new ClassLocator.ClassLocation(ClassUtils.getSimpleName(clazz), this.name, ClassUtils.getPackageName(clazz), 2, clazz, moduleName.getName(), true));
    }

    public Optional<ClassLocator.ClassLocation> findFromSystem(String fullyQualifiedName, List<ImportDefinition> imports, IBoxContext context) {
        RequestBoxContext requestContext = context.getParentOfType(RequestBoxContext.class);
        DynamicClassLoader classLoader = requestContext == null ? JavaResolver.getSystemClassLoader() : requestContext.getRequestClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(fullyQualifiedName);
            return Optional.of(new ClassLocator.ClassLocation(ClassUtils.getSimpleName(clazz), this.name, ClassUtils.getPackageName(clazz), 2, clazz, null, true));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    protected boolean importHas(IBoxContext context, ImportDefinition thisImport, String className) {
        return thisImport.isMultiImport() != false ? this.importHasMulti(context, thisImport, className) : super.importHas(context, thisImport, className);
    }

    @Override
    protected boolean importHasMulti(IBoxContext context, ImportDefinition thisImport, String className) {
        if (thisImport.className().matches("(?i)(java|javax)\\..*")) {
            logger.debug("Checking if [{}] is a JDK class", (Object)thisImport.getFullyQualifiedClass(className));
            if (this.jdkClassImportCache.contains(thisImport.getFullyQualifiedClass(className))) {
                return true;
            }
            try {
                Class.forName(thisImport.getFullyQualifiedClass(className), false, JavaResolver.getSystemClassLoader());
                this.jdkClassImportCache.add(thisImport.getFullyQualifiedClass(className));
                logger.debug("Found JDK Class [{}] and added to jdk import cache", (Object)thisImport.getFullyQualifiedClass(className));
                return true;
            }
            catch (ClassNotFoundException e) {
                logger.debug("Could not find JDK Class [{}]", (Object)thisImport.getFullyQualifiedClass(className));
                return false;
            }
        }
        return super.importHasMulti(context, thisImport, className);
    }

    public void clearJdkImportCache() {
        this.jdkClassImportCache.clear();
    }

    public Set<String> getJdkImportCache() {
        return this.jdkClassImportCache;
    }

    public Integer getJdkImportCacheSize() {
        return this.jdkClassImportCache.size();
    }

    static {
        logger = LoggerFactory.getLogger(JavaResolver.class);
    }
}

