/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.logging;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.scopes.Key;

public class LogLevel {
    public static final Key OFF = Key.of("off");
    public static final Key FATAL = Key.of("fatal");
    public static final Key ERROR = Key.of("error");
    public static final Key WARN = Key.of("warn");
    public static final Key INFO = Key.of("info");
    public static final Key DEBUG = Key.of("debug");
    public static final Key TRACE = Key.of("trace");
    public static final Key ALL = Key.of("all");

    public static Key valueOf(String level, Boolean safe) {
        switch (level.toLowerCase()) {
            case "off": {
                return OFF;
            }
            case "fatal": 
            case "fatal information": {
                return FATAL;
            }
            case "error": {
                return ERROR;
            }
            case "warn": 
            case "warning": {
                return WARN;
            }
            case "info": 
            case "information": {
                return INFO;
            }
            case "debug": {
                return DEBUG;
            }
            case "trace": {
                return TRACE;
            }
            case "all": {
                return ALL;
            }
        }
        if (safe.booleanValue()) {
            return null;
        }
        throw new IllegalArgumentException("Invalid log level: " + level);
    }

    public static boolean isValid(String level) {
        return LogLevel.valueOf(level, true) != null;
    }

    public static Key[] getLevels() {
        return new Key[]{OFF, FATAL, ERROR, WARN, INFO, DEBUG, TRACE, ALL};
    }

    public static List<String> getLevelsList() {
        return Arrays.stream(LogLevel.getLevels()).map(Key::getName).collect(Collectors.toList());
    }

    public static String[] getLevelsStrings() {
        return LogLevel.getLevelsList().toArray(new String[0]);
    }
}

