/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextAwareBase;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;

public class LoggingConfigurator
extends LoggerContextAwareBase
implements Configurator {
    public static String LOG_FORMAT = "%date %logger{0} [%level] %kvp %message%n";
    public static PatternLayoutEncoder encoder;

    @Override
    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        loggerContext.setName("BoxLang");
        encoder = new PatternLayoutEncoder();
        encoder.setContext(loggerContext);
        encoder.setPattern(LOG_FORMAT);
        encoder.start();
        Boolean debugMode = BoxRuntime.getInstance().inDebugMode();
        Level logLevel = Boolean.TRUE.equals(debugMode) ? Level.DEBUG : Level.WARN;
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setContext(loggerContext);
        appender.setEncoder(encoder);
        appender.start();
        Logger rootLogger = loggerContext.getLogger("ROOT");
        rootLogger.setLevel(logLevel);
        rootLogger.addAppender((Appender<ILoggingEvent>)appender);
        this.setLoggerContext(loggerContext);
        return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
    }

    public static void reconfigureDebugMode(Boolean debugMode) {
        Level logLevel = Boolean.TRUE.equals(debugMode) ? Level.DEBUG : Level.INFO;
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        rootLogger.setLevel(logLevel);
    }

    @Override
    public void setContext(Context context) {
        if (this.context == null) {
            this.context = context;
        } else if (this.context != context) {
            this.getLoggerContext().getLogger("ROOT").error("LoggingConfigurator context has been already set and an attempt to overwrite was made.");
        }
    }
}

