/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.modules;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.async.tasks.IScheduler;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.bifs.BoxLangBIFProxy;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.config.segments.ModuleConfig;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.IInterceptor;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.jdbc.drivers.DriverShim;
import ortus.boxlang.runtime.jdbc.drivers.IJDBCDriver;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.RunnableLoader;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.services.IService;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.StructUtil;
import ortus.boxlang.runtime.util.DataNavigator;
import ortus.boxlang.runtime.util.EncryptionUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class ModuleRecord {
    public final String id = UUID.randomUUID().toString();
    public Key name;
    public String version = "1.0.0";
    public String author = "";
    public String description = "";
    public String webURL = "";
    public String mapping;
    public boolean disabled = false;
    public boolean activated = false;
    public Struct settings = new Struct();
    public Struct objectMappings = new Struct();
    public Struct datasources = new Struct(IStruct.TYPES.LINKED);
    public Array interceptors = new Array();
    public Array bifs = new Array();
    public Array memberMethods = new Array();
    public Array customInterceptionPoints = new Array();
    public Path physicalPath;
    public String path;
    public String invocationPath;
    public Instant registeredOn;
    public long registrationTime = 0L;
    public Instant activatedOn;
    public long activationTime = 0L;
    public DynamicClassLoader classLoader = null;
    public IClassRunnable moduleConfig;
    private static final String MODULE_PACKAGE_NAME = "ortus.boxlang.runtime.modules.";
    private static final String MODULE_CONFIG_FILE = "box.json";
    private static final Logger logger = LoggerFactory.getLogger(ModuleRecord.class);

    public ModuleRecord(String physicalPath) {
        Path directoryPath = Path.of(physicalPath, new String[0]);
        Path boxjsonPath = directoryPath.resolve(MODULE_CONFIG_FILE);
        if (Files.exists(boxjsonPath, new LinkOption[0])) {
            DataNavigator.of(boxjsonPath).from("boxlang").ifPresent("moduleName", value -> {
                this.name = Key.of(value);
            });
        }
        if (this.name == null) {
            this.name = Key.of(directoryPath.getFileName().toString());
        }
        this.path = physicalPath;
        this.physicalPath = Paths.get(physicalPath, new String[0]);
        this.mapping = "/bxModules/" + this.name.getName();
        this.invocationPath = "bxModules." + this.name.getName();
    }

    public ModuleRecord loadDescriptor(IBoxContext context) {
        String castedMapping;
        Object object;
        BoxRuntime runtime = BoxRuntime.getInstance();
        Path descriptorPath = this.physicalPath.resolve("ModuleConfig.bx");
        String packageName = MODULE_PACKAGE_NAME + this.name.getNameNoCase() + EncryptionUtil.hash(this.physicalPath.toString());
        this.moduleConfig = (IClassRunnable)DynamicObject.of(RunnableLoader.getInstance().loadClass(ResolvedFilePath.of(null, null, packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + File.separator + "ModuleConfig.bx", descriptorPath), context)).invokeConstructor(context).getTargetInstance();
        ThisScope thisScope = this.moduleConfig.getThisScope();
        VariablesScope variablesScope = this.moduleConfig.getVariablesScope();
        this.version = (String)thisScope.getOrDefault(Key.version, (Object)"1.0.0");
        this.author = (String)thisScope.getOrDefault(Key.author, (Object)"");
        this.description = (String)thisScope.getOrDefault(Key.description, (Object)"");
        this.webURL = (String)thisScope.getOrDefault(Key.webURL, (Object)"");
        this.disabled = (Boolean)thisScope.getOrDefault(Key.disabled, (Object)false);
        if (runtime.getConfiguration().modules.containsKey(this.name)) {
            ModuleConfig config = (ModuleConfig)runtime.getConfiguration().modules.get(this.name);
            this.disabled = config.disabled;
        }
        if (thisScope.containsKey(Key.mapping) && (object = thisScope.get(Key.mapping)) instanceof String && !(castedMapping = (String)object).isBlank()) {
            this.mapping = "/bxModules/" + castedMapping;
            this.invocationPath = "bxModules." + castedMapping;
        }
        variablesScope.computeIfAbsent(Key.settings, k -> new Struct());
        variablesScope.computeIfAbsent(Key.objectMappings, k -> new Struct());
        variablesScope.computeIfAbsent(Key.datasources, k -> new Struct(IStruct.TYPES.LINKED));
        variablesScope.computeIfAbsent(Key.interceptors, k -> Array.of(new Object[0]));
        variablesScope.computeIfAbsent(Key.customInterceptionPoints, k -> Array.of(new Object[0]));
        variablesScope.put(Key.moduleRecord, (Object)this);
        variablesScope.put(Key.boxRuntime, (Object)BoxRuntime.getInstance());
        variablesScope.put(Key.interceptorService, (Object)BoxRuntime.getInstance().getInterceptorService());
        variablesScope.put(Key.log, (Object)LoggerFactory.getLogger(this.moduleConfig.getClass()));
        return this;
    }

    public ModuleRecord register(IBoxContext context) {
        Path bifsPath;
        ThisScope thisScope = this.moduleConfig.getThisScope();
        VariablesScope variablesScope = this.moduleConfig.getVariablesScope();
        BoxRuntime runtime = BoxRuntime.getInstance();
        InterceptorService interceptorService = runtime.getInterceptorService();
        FunctionService functionService = runtime.getFunctionService();
        ComponentService componentService = runtime.getComponentService();
        runtime.getConfiguration().registerMapping(this.mapping, this.path);
        try {
            this.classLoader = new DynamicClassLoader(this.name, this.physicalPath.toUri().toURL(), (ClassLoader)runtime.getRuntimeLoader(), (Boolean)false);
        }
        catch (MalformedURLException e) {
            logger.error("Error creating module [{}] class loader.", (Object)this.name, (Object)e);
            throw new BoxRuntimeException("Error creating module [" + String.valueOf(this.name) + "] class loader", e);
        }
        Path libsPath = this.physicalPath.resolve("libs");
        if (Files.exists(libsPath, new LinkOption[0]) && Files.isDirectory(libsPath, new LinkOption[0])) {
            try {
                this.classLoader.addURLs(DynamicClassLoader.getJarURLs(libsPath));
            }
            catch (IOException e) {
                logger.error("Error while seeding the module [{}] class loader with the libs folder.", (Object)this.name, (Object)e);
                throw new BoxRuntimeException("Error while seeding the module [" + String.valueOf(this.name) + "] class loader with the libs folder", e);
            }
        }
        if (thisScope.containsKey(Key.configure)) {
            this.moduleConfig.dereferenceAndInvoke(context, Key.configure, DynamicObject.EMPTY_ARGS, (Boolean)false);
        }
        this.settings = (Struct)variablesScope.getAsStruct(Key.settings);
        if (runtime.getConfiguration().modules.containsKey(this.name)) {
            ModuleConfig config = (ModuleConfig)runtime.getConfiguration().modules.get(this.name);
            StructUtil.deepMerge(this.settings, config.settings, true);
        }
        this.interceptors = variablesScope.getAsArray(Key.interceptors);
        this.customInterceptionPoints = variablesScope.getAsArray(Key.customInterceptionPoints);
        this.objectMappings = (Struct)variablesScope.getAsStruct(Key.objectMappings);
        this.datasources = (Struct)variablesScope.getAsStruct(Key.datasources);
        if (!this.customInterceptionPoints.isEmpty()) {
            interceptorService.registerInterceptionPoint((Key[])this.customInterceptionPoints.stream().map(Key::of).toArray(Key[]::new));
        }
        if (Files.exists(bifsPath = this.physicalPath.resolve("bifs"), new LinkOption[0]) && Files.isDirectory(bifsPath, new LinkOption[0])) {
            for (File targetFile : bifsPath.toFile().listFiles()) {
                this.registerBIF(targetFile, context);
            }
        }
        ServiceLoader.load(IService.class, this.classLoader).stream().map(ServiceLoader.Provider::get).forEach(service -> runtime.putGlobalService(service.getName(), (IService)service));
        ServiceLoader.load(Driver.class, this.classLoader).stream().map(ServiceLoader.Provider::get).forEach(driver -> {
            try {
                DriverManager.registerDriver(new DriverShim((Driver)driver));
            }
            catch (SQLException e) {
                throw new BoxRuntimeException(e.getMessage());
            }
        });
        ServiceLoader.load(IJDBCDriver.class, this.classLoader).stream().map(ServiceLoader.Provider::get).forEach(driver -> runtime.getDataSourceService().registerDriver((IJDBCDriver)driver));
        ServiceLoader.load(BIF.class, this.classLoader).stream().map(ServiceLoader.Provider::type).forEach(clazz -> functionService.processBIFRegistration((Class<?>)clazz, null, this.name.getName()));
        ServiceLoader.load(Component.class, this.classLoader).stream().map(ServiceLoader.Provider::type).forEach(targetClass -> componentService.registerComponent((Class<?>)targetClass, null, this.name.getName()));
        ServiceLoader.load(IScheduler.class, this.classLoader).stream().map(ServiceLoader.Provider::get).forEach(scheduler -> runtime.getSchedulerService().loadScheduler(Key.of(scheduler.getName() + "@" + String.valueOf(this.name)), (IScheduler)scheduler));
        ServiceLoader.load(ICacheProvider.class, this.classLoader).stream().map(ServiceLoader.Provider::type).forEach(provider -> runtime.getCacheService().registerProvider(Key.of(provider.getSimpleName()), (Class<? extends ICacheProvider>)provider));
        ServiceLoader.load(IInterceptor.class, this.classLoader).stream().map(ServiceLoader.Provider::get).forEach(interceptorService::register);
        this.registeredOn = Instant.now();
        return this;
    }

    private ModuleRecord registerBIF(File targetFile, IBoxContext context) {
        Key[] bifAliases;
        if (targetFile.isDirectory() || !targetFile.getName().matches("^.*\\.(cfc|bx)$")) {
            return this;
        }
        BoxRuntime runtime = BoxRuntime.getInstance();
        FunctionService functionService = runtime.getFunctionService();
        InterceptorService interceptorService = runtime.getInterceptorService();
        Key className = Key.of(FilenameUtils.getBaseName(targetFile.getAbsolutePath()));
        IClassRunnable oBIF = (IClassRunnable)DynamicObject.of(RunnableLoader.getInstance().loadClass(ResolvedFilePath.of(null, null, (this.invocationPath + ".bifs").replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + File.separator + FilenameUtils.getBaseName(targetFile.getAbsolutePath()), targetFile.toPath()), context)).invokeConstructor(context).getTargetInstance();
        oBIF.getVariablesScope().put(Key.moduleRecord, (Object)this);
        oBIF.getVariablesScope().put(Key.boxRuntime, (Object)runtime);
        oBIF.getVariablesScope().put(Key.functionService, (Object)functionService);
        oBIF.getVariablesScope().put(Key.interceptorService, (Object)interceptorService);
        oBIF.getVariablesScope().put(Key.log, (Object)LoggerFactory.getLogger(oBIF.getClass()));
        BIFDescriptor bifDescriptor = new BIFDescriptor(className, oBIF.getClass(), this.name.getName(), null, true, new BoxLangBIFProxy(oBIF));
        for (Key bifAlias : bifAliases = this.buildBIFAliases(oBIF, className)) {
            functionService.registerGlobalFunction(bifDescriptor, bifAlias, true);
            logger.info("> Registered Module [{}] BIF [{}] with alias [{}]", this.name.getName(), className.getName(), bifAlias.getName());
            this.bifs.push(bifAlias);
        }
        Array bifMemberMethods = this.discoverMemberMethods(oBIF, className);
        for (Object memberMethod : bifMemberMethods) {
            Key memberKey = Key.of(((IStruct)memberMethod).getAsString(Key._NAME));
            BoxLangType memberType = (BoxLangType)((Object)((IStruct)memberMethod).get(Key.type));
            String objectArgument = ((IStruct)memberMethod).getAsString(Key.objectArgument);
            functionService.registerMemberMethod(memberKey, new MemberDescriptor(memberKey, memberType, Object.class, objectArgument.isEmpty() ? null : Key.of(objectArgument), bifDescriptor));
            logger.info("> Registered Module [{}] MemberMethod [{}]", (Object)this.name.getName(), memberMethod);
            this.memberMethods.push(memberMethod);
        }
        return this;
    }

    private Array discoverMemberMethods(IClassRunnable targetBIF, Key className) {
        Object castedBoxMember;
        Object boxMembers = targetBIF.getBoxMeta().getMeta().getAsStruct(Key.annotations).getOrDefault(Key.boxMember, null);
        if (boxMembers == null) {
            return new Array();
        }
        if (boxMembers instanceof String && ((String)(castedBoxMember = (String)boxMembers)).isBlank()) {
            throw new BoxRuntimeException(className.getName() + " BoxMember annotation is missing it's type value, which is mandatory");
        }
        if (boxMembers instanceof String && !((String)(castedBoxMember = (String)boxMembers)).isBlank()) {
            if (!BoxLangType.isValid((String)castedBoxMember)) {
                throw new BoxRuntimeException(className.getName() + " BoxMember annotation has an invalid type value [" + (String)castedBoxMember + "]Valid types are: " + Arrays.toString((Object[])BoxLangType.values()));
            }
            BoxLangType boxType = BoxLangType.valueOf(((String)castedBoxMember).toUpperCase());
            return Array.of(new Object[]{Struct.of(new Object[]{Key._NAME, className.getNameNoCase().replaceAll(boxType.getKey().getNameNoCase(), ""), Key.objectArgument, "", Key.type, boxType})});
        }
        if (boxMembers instanceof IStruct) {
            castedBoxMember = (IStruct)boxMembers;
            Array result = new Array();
            for (Map.Entry<Key, Object> entry : castedBoxMember.entrySet()) {
                Key type = entry.getKey();
                if (!BoxLangType.isValid(type)) {
                    throw new BoxRuntimeException(className.getName() + " BoxMember annotation has an invalid type value [" + type.getName() + "]Valid types are: " + Arrays.toString((Object[])BoxLangType.values()));
                }
                Object object = entry.getValue();
                if (!(object instanceof IStruct)) {
                    throw new BoxRuntimeException(className.getName() + " BoxMember annotation value must be a struct with the following keys: [name], [objectArgument]");
                }
                IStruct memberRecord = (IStruct)object;
                BoxLangType boxType = BoxLangType.valueOf(type.getNameNoCase());
                memberRecord.put(Key.type, (Object)boxType);
                memberRecord.computeIfAbsent(Key._NAME, k -> className.getNameNoCase().replaceAll(type.getNameNoCase(), ""));
                memberRecord.putIfAbsent(Key.objectArgument, (Object)"");
                result.push(memberRecord);
            }
            return result;
        }
        return new Array();
    }

    private Key[] buildBIFAliases(IClassRunnable targetBIF, Key className) {
        String castedAnnotationWithValue;
        String castedAnnotation;
        Object boxBifAnnotation = targetBIF.getBoxMeta().getMeta().getAsStruct(Key.annotations).getOrDefault(Key.boxBif, (Object)"");
        if (boxBifAnnotation instanceof String && (castedAnnotation = (String)boxBifAnnotation).isBlank()) {
            return new Key[]{className};
        }
        if (boxBifAnnotation instanceof String && !(castedAnnotationWithValue = (String)boxBifAnnotation).isBlank()) {
            return new Key[]{Key.of(castedAnnotationWithValue)};
        }
        if (boxBifAnnotation instanceof Array) {
            Array castedAliases = (Array)boxBifAnnotation;
            return (Key[])castedAliases.push(className).stream().map(Key::of).toArray(Key[]::new);
        }
        return new Key[]{className};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleRecord unload(IBoxContext context) {
        ThisScope thisScope = this.moduleConfig.getThisScope();
        InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();
        if (thisScope.containsKey(Key.onUnload)) {
            try {
                this.moduleConfig.dereferenceAndInvoke(context, Key.onUnload, DynamicObject.EMPTY_ARGS, (Boolean)false);
            }
            catch (Exception e) {
                logger.error("Error while unloading module [{}]", (Object)this.name, (Object)e);
            }
        }
        if (!this.interceptors.isEmpty()) {
            for (Object interceptor : this.interceptors) {
                IStruct interceptorRecord = (IStruct)interceptor;
                IClassRunnable interceptorInstance = (IClassRunnable)interceptorRecord.get(Key.interceptor);
                if (interceptorInstance == null) continue;
                interceptorService.unregister(DynamicObject.of(interceptorInstance));
            }
        }
        interceptorService.unregister(DynamicObject.of(this.moduleConfig));
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            logger.error("Error while closing the DynamicClassLoader for module [{}]", (Object)this.name, (Object)e);
        }
        finally {
            this.classLoader = null;
        }
        return this;
    }

    public Class<?> findModuleClass(String className, Boolean safe, IBoxContext context) throws ClassNotFoundException {
        return this.classLoader.findClass(className, safe);
    }

    public ModuleRecord activate(IBoxContext context) {
        ThisScope thisScope = this.moduleConfig.getThisScope();
        InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();
        interceptorService.register(this.moduleConfig);
        if (!this.interceptors.isEmpty()) {
            for (Object interceptor : this.interceptors) {
                IStruct interceptorRecord = (IStruct)interceptor;
                if (!interceptorRecord.containsKey(Key._CLASS)) {
                    throw new BoxRuntimeException("Interceptor record is missing the [class] key which is mandatory");
                }
                String interceptorClass = interceptorRecord.getAsString(Key._CLASS);
                interceptorRecord.computeIfAbsent(Key.properties, k -> new Struct());
                interceptorRecord.computeIfAbsent(Key._NAME, k -> interceptorClass + "@" + String.valueOf(this.name));
                interceptorRecord.put(Key.interceptor, (Object)interceptorService.newAndRegister(interceptorClass, interceptorRecord.getAsStruct(Key.properties), interceptorRecord.getAsString(Key._NAME), this));
            }
        }
        if (thisScope.containsKey(Key.onLoad)) {
            this.moduleConfig.dereferenceAndInvoke(context, Key.onLoad, DynamicObject.EMPTY_ARGS, (Boolean)false);
        }
        this.activated = true;
        this.activatedOn = Instant.now();
        return this;
    }

    public void execute(IBoxContext context, String[] args) {
        ThisScope thisScope = this.moduleConfig.getThisScope();
        if (!thisScope.containsKey(Key.main)) {
            throw new BoxRuntimeException("Module " + this.id + " is not executable. It must have a 'main' method");
        }
        this.moduleConfig.dereferenceAndInvoke(context, Key.main, new Object[]{Array.fromArray(args)}, (Boolean)false);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public String toString() {
        return this.asStruct().toString();
    }

    public IStruct asStruct() {
        return Struct.of("activatedOn", this.activatedOn, "activationTime", this.activationTime, "activated", this.activated, "author", this.author, "customInterceptionPoints", Array.copyOf(this.customInterceptionPoints), "description", this.description, "disabled", this.disabled, "Id", this.id, "interceptors", Array.copyOf(this.interceptors), "invocationPath", this.invocationPath, "mapping", this.mapping, "name", this.name, "physicalPath", this.physicalPath.toString(), "registeredOn", this.registeredOn, "registrationTime", this.registrationTime, "settings", this.settings, "version", this.version, "webURL", this.webURL);
    }
}

