/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ortus.boxlang.runtime.net.NameValuePair;

public class URIBuilder {
    @Nullable
    private String scheme;
    @Nullable
    private String userInfo;
    @Nullable
    private String host;
    @Nullable
    private Integer port;
    @Nullable
    private String path;
    @Nonnull
    private List<NameValuePair> queryParams;
    @Nonnull
    private String fragment;
    @Nonnull
    private Charset charset;

    public URIBuilder() throws URISyntaxException {
        this("");
    }

    public URIBuilder(@Nonnull String string) throws URISyntaxException {
        this(string, Charset.defaultCharset());
    }

    public URIBuilder(@Nonnull String string, @Nonnull Charset charset) throws URISyntaxException {
        this(URI.create(string), charset);
    }

    public URIBuilder(@Nonnull URI uri) throws URISyntaxException {
        this(uri, Charset.defaultCharset());
    }

    public URIBuilder(@Nonnull URI uri, @Nonnull Charset charset) throws URISyntaxException {
        this.scheme = uri.getScheme();
        this.userInfo = uri.getUserInfo();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path = uri.getPath();
        this.charset = charset;
        this.queryParams = this.parseQueryString(uri.getQuery());
        this.fragment = uri.getFragment();
    }

    public void addParameter(@Nonnull String name, @Nullable String value) {
        this.queryParams.add(new NameValuePair(name, value));
    }

    public URI build() throws URISyntaxException {
        return new URI(this.scheme, this.userInfo, this.host, this.port != null ? this.port : -1, this.path, this.queryParams.stream().map(NameValuePair::toString).collect(Collectors.joining("&")), this.fragment);
    }

    private List<NameValuePair> parseQueryString(String queryString) {
        ArrayList<NameValuePair> newPairs = new ArrayList<NameValuePair>();
        if (queryString != null) {
            for (String pair : queryString.split("&")) {
                String[] nameAndValue = pair.split("=");
                newPairs.add(NameValuePair.fromNativeArray(nameAndValue));
            }
        }
        return newPairs;
    }
}

