/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.operators.StringCompare;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class Compare
implements IOperator {
    public static int invoke(Object left, Object right) {
        return Compare.invoke(left, right, false);
    }

    public static int invoke(Object left, Object right, Boolean caseSensitive) {
        return Compare.attempt(left, right, caseSensitive, true);
    }

    public static Integer attempt(Object left, Object right, Boolean caseSensitive, boolean fail) {
        return Compare.attempt(left, right, caseSensitive, fail, Locale.US);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Integer attempt(Object left, Object right, Boolean caseSensitive, boolean fail, Locale locale) {
        CastAttempt<Number> rightAttempt;
        if (left == null && right == null) {
            return 0;
        }
        if (left == null && right != null) {
            return -1;
        }
        if (left != null && right == null) {
            return 1;
        }
        left = DynamicObject.unWrap(left);
        right = DynamicObject.unWrap(right);
        if (DateTimeCaster.isKnownDateClass(left) || DateTimeCaster.isKnownDateClass(right)) {
            DateTime ref = DateTimeCaster.cast(left);
            DateTime target = DateTimeCaster.cast(right);
            return ref.compareTo(target);
        }
        CastAttempt<Number> leftAttempt = NumberCaster.attempt(left);
        if (leftAttempt.wasSuccessful() && (rightAttempt = NumberCaster.attempt(right)).wasSuccessful()) {
            boolean isLeft = leftAttempt.get() instanceof BigDecimal;
            boolean isRight = rightAttempt.get() instanceof BigDecimal;
            if (!isLeft) {
                if (!isRight) return Double.valueOf(leftAttempt.get().doubleValue()).compareTo(rightAttempt.get().doubleValue());
            }
            BigDecimal bdl = isLeft ? (BigDecimal)leftAttempt.get() : BigDecimalCaster.cast(leftAttempt.get());
            BigDecimal bdr = isRight ? (BigDecimal)rightAttempt.get() : BigDecimalCaster.cast(rightAttempt.get());
            return bdl.compareTo(bdr);
        }
        if (left instanceof String || right instanceof String) {
            if (!caseSensitive.booleanValue()) {
                left = StringUtils.lowerCase(left.toString(), locale);
                right = StringUtils.lowerCase(right.toString(), locale);
                return StringCompare.invoke(StringCaster.cast(left), StringCaster.cast(right), caseSensitive);
            }
            if (!DateTimeCaster.attempt(left).wasSuccessful()) return StringCompare.invoke(StringCaster.cast(left), StringCaster.cast(right), caseSensitive);
            if (!DateTimeCaster.attempt(right).wasSuccessful()) return StringCompare.invoke(StringCaster.cast(left), StringCaster.cast(right), caseSensitive);
            DateTime ref = DateTimeCaster.cast(left);
            DateTime target = DateTimeCaster.cast(right);
            return ref.compareTo(target);
        }
        if (left instanceof Comparable && right instanceof Comparable) {
            Integer n;
            if (caseSensitive.booleanValue() && left instanceof Key) {
                Key keyLeft = (Key)left;
                if (right instanceof Key) {
                    Key keyRight = (Key)right;
                    n = keyLeft.compareToWithCase(keyRight);
                    return n;
                }
            }
            n = ((Comparable)left).compareTo((Comparable)right);
            return n;
        }
        if (!fail) return null;
        throw new BoxRuntimeException(String.format("Can't compare [%s] against [%s]", left.getClass().getName(), right.getClass().getName()));
    }
}

