/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.util.List;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;

public class InstanceOf
implements IOperator {
    public static Boolean invoke(IBoxContext context, Object left, Object right) {
        Class<?> leftClass;
        IClassRunnable boxClass2;
        String boxClassName;
        if (left == null) {
            return false;
        }
        IClassRunnable boxClass = null;
        String type = StringCaster.cast(right);
        if ((left = DynamicObject.unWrap(left)) instanceof IClassRunnable && InstanceOf.looseClassCheck(boxClassName = (boxClass = (boxClass2 = (IClassRunnable)left)).getName().getName(), type)) {
            return true;
        }
        if (InstanceOf.looseClassCheck(left.getClass().getName(), type)) {
            return true;
        }
        if (boxClass != null) {
            IClassRunnable _super = boxClass;
            while ((_super = _super.getSuper()) != null) {
                boxClassName = _super.getName().getName();
                if (InstanceOf.looseClassCheck(boxClassName, type)) {
                    return true;
                }
                if (!InstanceOf.checkInterfaces(_super.getInterfaces(), type).booleanValue()) continue;
                return true;
            }
            if (InstanceOf.checkInterfaces(boxClass.getInterfaces(), type).booleanValue()) {
                return true;
            }
        }
        if (InstanceOf.isAssignableFromIgnoreCase(type, leftClass = left.getClass())) {
            return true;
        }
        return false;
    }

    private static Boolean checkInterfaces(List<BoxInterface> interfaces, String type) {
        for (BoxInterface boxInterface : interfaces) {
            if (!InstanceOf.checkInterface(type, boxInterface).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static Boolean checkInterface(String type, BoxInterface boxInterface) {
        if (InstanceOf.looseClassCheck(boxInterface.getName().getName(), type)) {
            return true;
        }
        if (boxInterface.getSupers().size() > 0 && InstanceOf.checkInterfaces(boxInterface.getSupers(), type).booleanValue()) {
            return true;
        }
        return false;
    }

    private static boolean isAssignableFromIgnoreCase(String targetTypeName, Class<?> leftClass) {
        while (leftClass != null) {
            if (InstanceOf.looseClassCheck(leftClass.getName(), targetTypeName)) {
                return true;
            }
            if (InstanceOf.checkJavaInterfaces(leftClass.getInterfaces(), targetTypeName)) {
                return true;
            }
            leftClass = leftClass.getSuperclass();
        }
        return false;
    }

    private static boolean checkJavaInterfaces(Class<?>[] interfaces, String targetTypeName) {
        for (Class<?> iface : interfaces) {
            if (InstanceOf.looseClassCheck(iface.getName(), targetTypeName)) {
                return true;
            }
            if (!InstanceOf.checkJavaInterfaces(iface.getInterfaces(), targetTypeName)) continue;
            return true;
        }
        return false;
    }

    private static boolean looseClassCheck(String actual, String expected) {
        return actual.equalsIgnoreCase(expected) || actual.toLowerCase().endsWith("." + expected.toLowerCase());
    }
}

