/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.math.BigDecimal;
import java.math.RoundingMode;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.MathUtil;

public class IntegerDivide
implements IOperator {
    public static Number invoke(Object left, Object right) {
        Number nLeft = NumberCaster.cast(left);
        Number nRight = NumberCaster.cast(right);
        boolean leftIsBD = false;
        boolean rightIsBD = false;
        if (MathUtil.isHighPrecisionMath() || (leftIsBD = nLeft instanceof BigDecimal) || (rightIsBD = nRight instanceof BigDecimal)) {
            BigDecimal bdLeft = leftIsBD ? (BigDecimal)nLeft : BigDecimalCaster.cast(nLeft);
            BigDecimal bdRight = rightIsBD ? (BigDecimal)nRight : BigDecimalCaster.cast(nRight);
            bdLeft = bdLeft.setScale(0, RoundingMode.FLOOR);
            if ((bdRight = bdRight.setScale(0, RoundingMode.FLOOR)).doubleValue() == 0.0) {
                throw new BoxRuntimeException("You cannot divide by zero.");
            }
            return bdLeft.divideToIntegralValue(bdRight, MathUtil.getMathContext());
        }
        if (nRight.doubleValue() == 0.0) {
            throw new BoxRuntimeException("You cannot divide by zero.");
        }
        return nLeft.intValue() / nRight.intValue();
    }
}

