/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.math.BigDecimal;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.MathUtil;

public class Modulus
implements IOperator {
    public static Number invoke(Object left, Object right) {
        Number nLeft = NumberCaster.cast(left);
        Number nRight = NumberCaster.cast(right);
        boolean leftIsBD = false;
        boolean rightIsBD = false;
        if (MathUtil.isHighPrecisionMath() || (leftIsBD = nLeft instanceof BigDecimal) || (rightIsBD = nRight instanceof BigDecimal)) {
            if (nRight.doubleValue() == 0.0) {
                throw new BoxRuntimeException("You cannot divide by zero.");
            }
            BigDecimal bdLeft = leftIsBD ? (BigDecimal)nLeft : BigDecimalCaster.cast(nLeft);
            BigDecimal bdRight = rightIsBD ? (BigDecimal)nRight : BigDecimalCaster.cast(nRight);
            return bdLeft.remainder(bdRight, MathUtil.getMathContext());
        }
        if (nRight.doubleValue() == 0.0) {
            throw new BoxRuntimeException("You cannot divide by zero.");
        }
        return nLeft.doubleValue() % nRight.doubleValue();
    }

    public static Number invoke(IBoxContext context, Object target, Key name, Object right) {
        Number result = Modulus.invoke(Referencer.get(context, target, name, false), right);
        Referencer.set(context, target, name, result);
        return result;
    }
}

