/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.math.BigDecimal;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.operators.IOperator;

public class Negate
implements IOperator {
    public static Number invoke(Object object) {
        Number nObject = NumberCaster.cast(object);
        if (nObject instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)nObject;
            BigDecimal d = bd.negate();
            if (d.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            return d;
        }
        if (nObject instanceof Integer) {
            int l = nObject.intValue();
            if (l == 0) {
                return 0;
            }
            return -l;
        }
        if (nObject instanceof Long) {
            long l = nObject.longValue();
            if (l == 0L) {
                return 0;
            }
            return -l;
        }
        double d = nObject.doubleValue();
        if (d == 0.0) {
            return 0;
        }
        return -d;
    }
}

