/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.math.BigDecimal;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.util.MathUtil;

public class Plus
implements IOperator {
    private static final long MAX_SAFE_LONG = 0x3FFFFFFFFFFFFFFFL;
    private static final long MIN_SAFE_LONG = -4611686018427387903L;

    public static Number invoke(Object left, Object right) {
        Number nLeft = NumberCaster.cast(left);
        Number nRight = NumberCaster.cast(right);
        if (nLeft instanceof Integer) {
            Long rl;
            Integer li = (Integer)nLeft;
            if (nRight instanceof Integer) {
                Integer ri = (Integer)nRight;
                return (long)li.intValue() + (long)ri.intValue();
            }
            if (nRight instanceof Long && (rl = (Long)nRight) <= 0x3FFFFFFFFFFFFFFFL && rl >= -4611686018427387903L) {
                return (long)li.intValue() + rl;
            }
        }
        if (nRight instanceof Integer) {
            Long ll;
            Integer ri = (Integer)nRight;
            if (nLeft instanceof Long && (ll = (Long)nLeft) <= 0x3FFFFFFFFFFFFFFFL && ll >= -4611686018427387903L) {
                return ll + (long)ri.intValue();
            }
        }
        boolean leftIsBD = false;
        boolean rightIsBD = false;
        if (MathUtil.isHighPrecisionMath() || (leftIsBD = nLeft instanceof BigDecimal) || (rightIsBD = nRight instanceof BigDecimal)) {
            BigDecimal bdLeft = leftIsBD ? (BigDecimal)nLeft : BigDecimalCaster.cast(nLeft);
            BigDecimal bdRight = rightIsBD ? (BigDecimal)nRight : BigDecimalCaster.cast(nRight);
            return bdLeft.add(bdRight, MathUtil.getMathContext());
        }
        return nLeft.doubleValue() + nRight.doubleValue();
    }

    public static Number invoke(IBoxContext context, Object target, Key name, Object right) {
        Number result = Plus.invoke(Referencer.get(context, target, name, false), right);
        Referencer.set(context, target, name, result);
        return result;
    }
}

