/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.math.BigDecimal;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.types.util.MathUtil;

public class Power
implements IOperator {
    public static Number invoke(Object left, Object right) {
        Number nLeft = NumberCaster.cast(left);
        Number nRight = NumberCaster.cast(right);
        boolean leftIsBD = false;
        boolean rightIsBD = false;
        if (MathUtil.isHighPrecisionMath() || (leftIsBD = nLeft instanceof BigDecimal) || (rightIsBD = nRight instanceof BigDecimal)) {
            BigDecimal bdRight;
            BigDecimal bdLeft = leftIsBD ? (BigDecimal)nLeft : BigDecimalCaster.cast(nLeft);
            BigDecimal bigDecimal = bdRight = rightIsBD ? (BigDecimal)nRight : BigDecimalCaster.cast(nRight);
            if (bdRight.stripTrailingZeros().scale() <= 0) {
                return bdLeft.pow(bdRight.intValueExact(), MathUtil.getMathContext());
            }
            BigDecimal logBase = new BigDecimal(Math.log(bdLeft.doubleValue()), MathUtil.getMathContext());
            BigDecimal result = new BigDecimal(Math.exp(logBase.multiply(bdRight).doubleValue()), MathUtil.getMathContext());
            return result;
        }
        return Math.pow(nLeft.doubleValue(), nRight.doubleValue());
    }
}

