/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.operators;

import java.text.Collator;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.operators.IOperator;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.util.LocalizationUtil;

public class StringCompare
implements IOperator {
    public static int invoke(String left, String right) {
        return StringCompare.invoke(left, right, false);
    }

    public static int invoke(String left, String right, Boolean caseSensitive) {
        return StringCompare.attempt(left, right, caseSensitive, true);
    }

    public static int invoke(String left, String right, Boolean caseSensitive, Locale locale) {
        return StringCompare.attempt(left, right, caseSensitive, true, locale);
    }

    public static Integer attempt(String left, String right, Boolean caseSensitive, boolean fail) {
        return StringCompare.attempt(left, right, caseSensitive, fail, Locale.US);
    }

    public static Integer attempt(String left, String right, Boolean caseSensitive, boolean fail, Locale locale) {
        Boolean containsUnicode = Stream.of(left.toString(), right.toString()).anyMatch(s -> s.codePoints().anyMatch(c -> c > 127));
        if (containsUnicode.booleanValue() || !locale.equals(LocalizationUtil.COMMON_LOCALES.get(Key.of("US"))) && !locale.equals(Locale.ENGLISH)) {
            Collator collator = Collator.getInstance(locale);
            return collator.getCollationKey(caseSensitive != false ? left.toString() : left.toString().toLowerCase(locale)).compareTo(collator.getCollationKey(caseSensitive != false ? right.toString() : right.toString().toLowerCase(locale)));
        }
        return caseSensitive != false ? StringUtils.compare(left.toString(), right.toString()) : StringUtils.compareIgnoreCase(left.toString(), right.toString());
    }
}

