/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.runnables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.AbstractFunction;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Property;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.ClassMeta;
import ortus.boxlang.runtime.util.ArgumentUtil;

public class BoxClassSupport {
    public static void pseudoConstructor(IClassRunnable thisClass, IBoxContext context) {
        context.pushTemplate(thisClass);
        try {
            thisClass._pseudoConstructor(context);
        }
        finally {
            context.popTemplate();
        }
    }

    public static void defaultProperties(IClassRunnable thisClass, IBoxContext context) {
        for (Property property : thisClass.getProperties().values()) {
            Object existing = thisClass.getVariablesScope().get(property.name());
            if (existing == null || existing instanceof Function) {
                thisClass.getVariablesScope().assign(context, property.name(), property.getDefaultValue(context));
            }
            if (!BoxClassSupport.hasAccessors(thisClass).booleanValue()) continue;
            context.registerUDF(property.generatedGetter(), false);
            context.registerUDF(property.generatedSetter(), false);
        }
    }

    public static BoxMeta getBoxMeta(IClassRunnable thisClass) {
        if (thisClass._getbx() == null) {
            thisClass._setbx(new ClassMeta(thisClass));
        }
        return thisClass._getbx();
    }

    public static String asString(IClassRunnable thisClass) {
        return "Class: " + thisClass.getName().getName();
    }

    public static Boolean canOutput(IClassRunnable thisClass) {
        if (thisClass.getCanOutput() == null) {
            thisClass.setCanOutput(BooleanCaster.cast(thisClass.getAnnotations().getOrDefault(Key.output, (Object)false)));
        }
        return thisClass.getCanOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean canInvokeImplicitAccessor(IClassRunnable thisClass, IBoxContext context) {
        if (thisClass.getCanInvokeImplicitAccessor() == null) {
            IClassRunnable iClassRunnable = thisClass;
            synchronized (iClassRunnable) {
                if (thisClass.getCanInvokeImplicitAccessor() == null) {
                    Object setting = thisClass.getAnnotations().get(Key.invokeImplicitAccessor);
                    if (setting == null) {
                        setting = context.getConfigItems(Key.applicationSettings, Key.invokeImplicitAccessor);
                    }
                    if (setting != null) {
                        thisClass.setCanInvokeImplicitAccessor(BooleanCaster.cast(setting));
                    } else {
                        thisClass.setCanInvokeImplicitAccessor(false);
                    }
                }
            }
        }
        return thisClass.getCanInvokeImplicitAccessor();
    }

    public static void setSuper(IClassRunnable thisClass, IClassRunnable _super) {
        thisClass._setSuper(_super);
        _super.setChild(thisClass);
        thisClass.getVariablesScope().addAll(_super.getVariablesScope().getWrapped());
        thisClass.getThisScope().addAll(_super.getThisScope().getWrapped());
        for (Map.Entry<Key, Property> entry : _super.getProperties().entrySet()) {
            if (thisClass.getProperties().containsKey(entry.getKey())) continue;
            thisClass.getProperties().put(entry.getKey(), entry.getValue());
        }
        thisClass.getGetterLookup().putAll(_super.getGetterLookup());
        thisClass.getSetterLookup().putAll(_super.getSetterLookup());
        for (Map.Entry<Key, Object> entry : _super.getAnnotations().entrySet()) {
            Key key = entry.getKey();
            if (thisClass.getAnnotations().containsKey(key) || key.equals(Key._EXTENDS) || key.equals(Key._IMPLEMENTS) || key.equals(Key._ABSTRACT)) continue;
            thisClass.getAnnotations().put(key, entry.getValue());
        }
    }

    public static IClassRunnable getBottomClass(IClassRunnable thisClass) {
        if (thisClass.getChild() != null) {
            return thisClass.getChild().getBottomClass();
        }
        return thisClass;
    }

    public static Object assign(IClassRunnable thisClass, IBoxContext context, Key key, Object value) {
        if (thisClass.canInvokeImplicitAccessor(context).booleanValue() && thisClass.getProperties().containsKey(key)) {
            return BoxClassSupport.dereferenceAndInvoke(thisClass, context, thisClass.getProperties().get(key).setterName(), new Object[]{value}, (Boolean)false);
        }
        if (!thisClass.getThisScope().containsKey(key) && thisClass.getStaticScope().containsKey(key)) {
            return BoxClassSupport.assignStatic(thisClass.getStaticScope(), context, key, value);
        }
        thisClass.getThisScope().assign(context, key, value);
        return value;
    }

    public static Object dereference(IClassRunnable thisClass, IBoxContext context, Key key, Boolean safe) {
        if (key.equals(BoxMeta.key)) {
            return thisClass.getBoxMeta();
        }
        if (thisClass.canInvokeImplicitAccessor(context).booleanValue() && thisClass.getProperties().containsKey(key)) {
            return BoxClassSupport.dereferenceAndInvoke(thisClass, context, thisClass.getProperties().get(key).getterName(), new Object[0], (Boolean)false);
        }
        if (thisClass.getThisScope().containsKey(key)) {
            return thisClass.getThisScope().dereference(context, key, safe);
        }
        if (thisClass.getStaticScope().containsKey(key)) {
            return thisClass.getStaticScope().dereference(context, key, safe);
        }
        if (thisClass.isJavaExtends()) {
            return DynamicObject.of(thisClass).setTargetClass(thisClass.getClass().getSuperclass()).dereference(context, key, safe);
        }
        if (safe.booleanValue()) {
            return null;
        }
        throw new KeyNotFoundException(String.format("The key [%s] was not found in the struct. Valid keys are (%s)", key.getName(), thisClass.getThisScope().getKeysAsStrings()));
    }

    public static Object dereferenceAndInvoke(IClassRunnable thisClass, IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        Object value;
        BaseScope scope = thisClass.getThisScope();
        if (thisClass.getChild() != null) {
            scope = thisClass.getVariablesScope();
        }
        if ((value = scope.get(name)) instanceof Function) {
            Function function = (Function)value;
            FunctionBoxContext functionContext = Function.generateFunctionContext(function, context, name, positionalArguments, thisClass, null);
            functionContext.setThisClass(thisClass);
            return function.invoke(functionContext);
        }
        if (thisClass.getSuper() != null && thisClass.getSuper().getThisScope().get(name) != null) {
            return thisClass.getSuper().dereferenceAndInvoke(context, name, positionalArguments, safe);
        }
        value = thisClass.getStaticScope().get(name);
        if (value instanceof Function) {
            return BoxClassSupport.dereferenceAndInvokeStatic(DynamicObject.of(thisClass.getClass()), thisClass.getStaticScope(), context, name, positionalArguments, safe);
        }
        if (value != null) {
            throw new BoxRuntimeException("key '" + name.getName() + "' of type  '" + value.getClass().getName() + "'  is not a function ");
        }
        MemberDescriptor memberDescriptor = BoxRuntime.getInstance().getFunctionService().getMemberMethod(name, BoxLangType.CLASS);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)thisClass, positionalArguments);
        }
        if (thisClass.getThisScope().get(Key.onMissingMethod) != null) {
            return thisClass.dereferenceAndInvoke(context, Key.onMissingMethod, new Object[]{name.getName(), ArgumentUtil.createArgumentsScope(context, positionalArguments)}, safe);
        }
        if (thisClass.isJavaExtends()) {
            return DynamicObject.of(thisClass).setTargetClass(thisClass.getClass().getSuperclass()).dereferenceAndInvoke(context, name, positionalArguments, safe);
        }
        if (!safe.booleanValue()) {
            throw new BoxRuntimeException("Method '" + name.getName() + "' not found");
        }
        return null;
    }

    public static Object dereferenceAndInvoke(IClassRunnable thisClass, IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        Object value;
        BaseScope scope = thisClass.getThisScope();
        if (thisClass.getChild() != null) {
            scope = thisClass.getVariablesScope();
        }
        if ((value = scope.get(name)) instanceof Function) {
            Function function = (Function)value;
            FunctionBoxContext functionContext = Function.generateFunctionContext(function, context, name, namedArguments, thisClass, null);
            functionContext.setThisClass(thisClass);
            return function.invoke(functionContext);
        }
        if (thisClass.getSuper() != null && thisClass.getSuper().getThisScope().get(name) != null) {
            return thisClass.getSuper().dereferenceAndInvoke(context, name, namedArguments, safe);
        }
        value = thisClass.getStaticScope().get(name);
        if (value instanceof Function) {
            return BoxClassSupport.dereferenceAndInvokeStatic(DynamicObject.of(thisClass.getClass()), thisClass.getStaticScope(), context, name, namedArguments, safe);
        }
        if (value != null) {
            throw new BoxRuntimeException("key '" + name.getName() + "' of type  '" + value.getClass().getName() + "'  is not a function ");
        }
        MemberDescriptor memberDescriptor = BoxRuntime.getInstance().getFunctionService().getMemberMethod(name, BoxLangType.CLASS);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)thisClass, namedArguments);
        }
        if (thisClass.getThisScope().get(Key.onMissingMethod) != null) {
            HashMap<Key, Object> args = new HashMap<Key, Object>();
            args.put(Key.missingMethodName, name.getName());
            args.put(Key.missingMethodArguments, ArgumentUtil.createArgumentsScope(context, namedArguments));
            return thisClass.dereferenceAndInvoke(context, Key.onMissingMethod, args, safe);
        }
        if (!safe.booleanValue()) {
            throw new BoxRuntimeException("Method '" + name.getName() + "' not found");
        }
        return null;
    }

    public static IStruct getMetaData(IClassRunnable thisClass) {
        Struct meta = new Struct(IStruct.TYPES.SORTED);
        meta.putIfAbsent("hint", (Object)"");
        meta.putIfAbsent("output", (Object)thisClass.canOutput());
        meta.putIfAbsent("invokeImplicitAccessor", (Object)thisClass.getCanInvokeImplicitAccessor());
        ArrayList<IStruct> functions = new ArrayList<IStruct>();
        Set<Key> compileTimeMethodNames = thisClass.getCompileTimeMethodNames();
        for (Key entry : compileTimeMethodNames) {
            Object object = thisClass.getVariablesScope().get(entry);
            if (!(object instanceof Function)) continue;
            Function fun = (Function)object;
            functions.add(fun.getMetaData());
        }
        meta.put("name", (Object)thisClass.getName().getName());
        meta.put("accessors", (Object)BoxClassSupport.hasAccessors(thisClass));
        meta.put("functions", (Object)Array.fromList(functions));
        Array properties = new Array();
        for (Map.Entry<Key, Property> entry : thisClass.getProperties().entrySet()) {
            Property property = entry.getValue();
            Struct propertyStruct = new Struct(IStruct.TYPES.LINKED);
            propertyStruct.put("name", (Object)property.name().getName());
            propertyStruct.put("type", (Object)property.type());
            if (property.hasDefaultValue()) {
                propertyStruct.put("default", property.getDefaultValueForMeta());
            }
            if (property.documentation() != null) {
                propertyStruct.putAll(property.documentation());
            }
            if (property.annotations() != null && property.annotations() != null) {
                for (Map.Entry<Key, Object> annotation : property.annotations().entrySet()) {
                    if (annotation.getKey().equals(Key._DEFAULT)) continue;
                    propertyStruct.put(annotation.getKey(), annotation.getValue());
                }
            }
            properties.add(propertyStruct);
        }
        meta.put("properties", (Object)properties);
        meta.put("type", (Object)"Component");
        meta.put("name", (Object)thisClass.getName().getName());
        meta.put("fullname", (Object)thisClass.getName().getName());
        meta.put("path", (Object)thisClass.getRunnablePath().absolutePath().toString());
        meta.put("persisent", (Object)false);
        if (thisClass.getDocumentation() != null) {
            meta.putAll(thisClass.getDocumentation());
        }
        if (thisClass.getAnnotations() != null) {
            meta.putAll(thisClass.getAnnotations());
        }
        if (thisClass.getSuper() != null) {
            meta.put("extends", (Object)thisClass.getSuper().getMetaData());
        }
        return meta;
    }

    public static void registerInterface(IClassRunnable thisClass, BoxInterface _interface) {
        _interface.validateClass(thisClass);
        VariablesScope variablesScope = thisClass.getVariablesScope();
        ThisScope thisScope = thisClass.getThisScope();
        thisClass.getInterfaces().add(_interface);
        for (Map.Entry<Key, Function> entry : _interface.getAllDefaultMethods().entrySet()) {
            if (!variablesScope.containsKey(entry.getKey())) {
                variablesScope.put(entry.getKey(), (Object)entry.getValue());
            }
            if (thisScope.containsKey(entry.getKey()) || entry.getValue().getAccess() != Function.Access.PUBLIC) continue;
            thisScope.put(entry.getKey(), (Object)entry.getValue());
        }
    }

    public static Object dereferenceAndInvokeStatic(DynamicObject targetClass, IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        StaticScope staticScope = BoxClassSupport.getStaticScope(context, targetClass);
        return BoxClassSupport.dereferenceAndInvokeStatic(targetClass, staticScope, context, name, namedArguments, safe);
    }

    public static Object dereferenceAndInvokeStatic(DynamicObject targetClass, IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        StaticScope staticScope = BoxClassSupport.getStaticScope(context, targetClass);
        return BoxClassSupport.dereferenceAndInvokeStatic(targetClass, staticScope, context, name, positionalArguments, safe);
    }

    public static Object assignStatic(DynamicObject targetClass, IBoxContext context, Key name, Object value) {
        StaticScope staticScope = BoxClassSupport.getStaticScope(context, targetClass);
        return BoxClassSupport.assignStatic(staticScope, context, name, value);
    }

    public static Object dereferenceStatic(DynamicObject targetClass, IBoxContext context, Key name, Boolean safe) {
        StaticScope staticScope = BoxClassSupport.getStaticScope(context, targetClass);
        return BoxClassSupport.dereferenceStatic(staticScope, context, name, safe);
    }

    public static Object dereferenceAndInvokeStatic(DynamicObject targetClass, StaticScope staticScope, IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        Object func = staticScope.get(name);
        if (func instanceof Function) {
            Function function = (Function)func;
            FunctionBoxContext functionContext = Function.generateFunctionContext(function, context, name, namedArguments, null, null);
            functionContext.setThisStaticClass(targetClass);
            return function.invoke(functionContext);
        }
        if (func != null) {
            throw new BoxRuntimeException("Key [" + name.getName() + "] in the static scope is not a method.");
        }
        throw new KeyNotFoundException(String.format("The key [%s] was not found in the struct. Valid keys are (%s)", name.getName(), staticScope.getKeysAsStrings()));
    }

    public static Object dereferenceAndInvokeStatic(DynamicObject targetClass, StaticScope staticScope, IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        Object func = staticScope.get(name);
        if (func instanceof Function) {
            Function function = (Function)func;
            FunctionBoxContext functionContext = Function.generateFunctionContext(function, context, name, positionalArguments, null, null);
            functionContext.setThisStaticClass(targetClass);
            return function.invoke(functionContext);
        }
        if (func != null) {
            throw new BoxRuntimeException("Key [" + name.getName() + "] in the static scope is not a method.");
        }
        throw new KeyNotFoundException(String.format("The key [%s] was not found in the struct. Valid keys are (%s)", name.getName(), staticScope.getKeysAsStrings()));
    }

    public static Object assignStatic(StaticScope staticScope, IBoxContext context, Key name, Object value) {
        staticScope.put(name, value);
        return value;
    }

    public static Object dereferenceStatic(StaticScope staticScope, IBoxContext context, Key name, Boolean safe) {
        return staticScope.dereference(context, name, safe);
    }

    public static StaticScope getStaticScope(IBoxContext context, DynamicObject targetClass) {
        return (StaticScope)targetClass.invokeStatic(context, "getStaticScopeStatic", new Object[0]);
    }

    public static IStruct getAnnotations(IBoxContext context, DynamicObject targetClass) {
        return (IStruct)targetClass.invokeStatic(context, "getAnnotationsStatic", new Object[0]);
    }

    public static Boolean canOutput(IBoxContext context, DynamicObject targetClass) {
        return BooleanCaster.cast(BoxClassSupport.getAnnotations(context, targetClass).getOrDefault(Key.output, (Object)false));
    }

    public static Boolean hasAccessors(IClassRunnable targetClass) {
        return BooleanCaster.cast(targetClass.getAnnotations().getOrDefault(Key.accessors, (Object)true));
    }

    public static DynamicObject ensureClass(IBoxContext context, Object obj, List<ImportDefinition> imports) {
        if (obj instanceof DynamicObject) {
            DynamicObject dynO = (DynamicObject)obj;
            return dynO;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return BoxRuntime.getInstance().getClassLocator().load(context, str, imports);
        }
        throw new BoxRuntimeException("Cannot load class for static access.  Type provided: " + obj.getClass().getName());
    }

    public static void validateAbstractMethods(IClassRunnable thisClass, Map<Key, AbstractFunction> abstractMethods) {
        String className = thisClass.getName().getName();
        if (thisClass.getThisScope().get(Key.onMissingMethod) instanceof Function) {
            return;
        }
        for (Map.Entry<Key, AbstractFunction> abstractMethod : abstractMethods.entrySet()) {
            Object object;
            if (thisClass.getThisScope().containsKey(abstractMethod.getKey()) && (object = thisClass.getThisScope().get(abstractMethod.getKey())) instanceof Function) {
                Function classMethod = (Function)object;
                if (classMethod.implementsSignature(abstractMethod.getValue()).booleanValue()) continue;
                throw new BoxRuntimeException("Class [" + className + "] has method [" + classMethod.signatureAsString() + "] but the signature doesn't match the signature of [" + abstractMethod.getValue().signatureAsString() + "] in " + abstractMethod.getValue().getSourceObjectType() + " [" + abstractMethod.getValue().getSourceObjectName() + "].");
            }
            throw new BoxRuntimeException("Class [" + className + "] does not implement method [" + abstractMethod.getValue().signatureAsString() + "] from " + abstractMethod.getValue().getSourceObjectType() + " [" + abstractMethod.getValue().getSourceObjectName() + "].");
        }
    }
}

