/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.runnables;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.ITemplateRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.types.AbstractFunction;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.InterfaceMeta;

public abstract class BoxInterface
implements ITemplateRunnable,
IReferenceable,
IType {
    public BoxMeta $bx;
    private Boolean canOutput = null;

    protected void resolveSupers(IBoxContext context) {
        String superInterfaceNames;
        Object superInterfaceObject = this.getAnnotations().get(Key._EXTENDS);
        if (superInterfaceObject != null && (superInterfaceNames = StringCaster.cast(superInterfaceObject)) != null && superInterfaceNames.length() > 0) {
            String[] superInterfaceNameArray;
            for (String superInterfaceName : superInterfaceNameArray = superInterfaceNames.split(",")) {
                if ((superInterfaceName = superInterfaceName.trim()).toLowerCase().startsWith("java:")) {
                    throw new BoxRuntimeException("BoxLang Interaces cannot extend Java interfaces");
                }
                BoxInterface _super = (BoxInterface)BoxRuntime.getInstance().getClassLocator().load(context, superInterfaceName, context.getCurrentImports()).unWrapBoxLangClass();
                this.addSuper(_super);
            }
        }
    }

    public void addSuper(BoxInterface _super) {
        this._addSuper(_super);
        for (Map.Entry<Key, Object> entry : _super.getAnnotations().entrySet()) {
            Key key = entry.getKey();
            if (this.getAnnotations().containsKey(key) || key.equals(Key._EXTENDS)) continue;
            this.getAnnotations().put(key, entry.getValue());
        }
    }

    public abstract Key getName();

    public abstract IStruct getAnnotations();

    public abstract IStruct getDocumentation();

    public abstract Map<Key, AbstractFunction> getAbstractMethods();

    public abstract Map<Key, Function> getDefaultMethods();

    public abstract StaticScope getStaticScope();

    public abstract void _addSuper(BoxInterface var1);

    public abstract List<BoxInterface> getSupers();

    @Override
    public String asString() {
        return "Interface: " + this.getName().getName();
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new InterfaceMeta(this);
        }
        return this.$bx;
    }

    public boolean canOutput() {
        if (this.canOutput == null) {
            this.canOutput = BooleanCaster.cast(this.getAnnotations().getOrDefault(Key.output, (Object)false));
        }
        return this.canOutput;
    }

    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        return this.getStaticScope().assign(context, key, value);
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        if (key.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        return this.getStaticScope().dereference(context, key, safe);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        Object func = this.getStaticScope().get(name);
        if (func instanceof Function) {
            Function function = (Function)func;
            FunctionBoxContext functionContext = Function.generateFunctionContext(function, context, name, positionalArguments, null, this);
            return function.invoke(functionContext);
        }
        if (func != null) {
            throw new BoxRuntimeException("Key [" + name.getName() + "] in the static scope is not a method.");
        }
        throw new KeyNotFoundException(String.format("The key [%s] was not found in the struct. Valid keys are (%s)", name.getName(), this.getStaticScope().getKeysAsStrings()));
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        Object func = this.getStaticScope().get(name);
        if (func instanceof Function) {
            Function function = (Function)func;
            FunctionBoxContext functionContext = Function.generateFunctionContext(function, context, name, namedArguments, null, this);
            return function.invoke(functionContext);
        }
        if (func != null) {
            throw new BoxRuntimeException("Key [" + name.getName() + "] in the static scope is not a method.");
        }
        throw new KeyNotFoundException(String.format("The key [%s] was not found in the struct. Valid keys are (%s)", name.getName(), this.getStaticScope().getKeysAsStrings()));
    }

    public IStruct getMetaData() {
        Function value;
        Struct meta = new Struct(IStruct.TYPES.SORTED);
        meta.putIfAbsent("hint", (Object)"");
        meta.putIfAbsent("output", (Object)this.canOutput());
        ArrayList<IStruct> functions = new ArrayList<IStruct>();
        for (Key entry : this.getAbstractMethods().keySet()) {
            value = this.getAbstractMethods().get(entry);
            functions.add(value.getMetaData());
        }
        for (Key entry : this.getDefaultMethods().keySet()) {
            value = this.getDefaultMethods().get(entry);
            functions.add(value.getMetaData());
        }
        meta.put("name", (Object)this.getName().getName());
        meta.put("accessors", (Object)false);
        meta.put("functions", (Object)Array.fromList(functions));
        meta.put("type", (Object)"Interface");
        meta.put("fullname", (Object)this.getName().getName());
        meta.put("path", (Object)this.getRunnablePath().absolutePath().toString());
        if (this.getDocumentation() != null) {
            meta.putAll(this.getDocumentation());
        }
        if (this.getAnnotations() != null) {
            meta.putAll(this.getAnnotations());
        }
        if (this.getSupers().size() > 0) {
            Struct supersMeta = new Struct(IStruct.TYPES.LINKED);
            for (BoxInterface _super : this.getSupers()) {
                supersMeta.put(_super.getName().getName(), (Object)_super.getMetaData());
            }
            meta.put("extends", (Object)supersMeta);
        }
        return meta;
    }

    void validateClass(IClassRunnable boxClass) {
        BoxClassSupport.validateAbstractMethods(boxClass, this.getAllAbstractMethods());
    }

    public Map<Key, AbstractFunction> getAllAbstractMethods() {
        LinkedHashMap<Key, AbstractFunction> methods = new LinkedHashMap<Key, AbstractFunction>();
        if (this.getSupers().size() > 0) {
            for (BoxInterface _super : this.getSupers()) {
                methods.putAll(_super.getAllAbstractMethods());
            }
        }
        methods.putAll(this.getAbstractMethods());
        return methods;
    }

    public Map<Key, Function> getAllDefaultMethods() {
        LinkedHashMap<Key, Function> methods = new LinkedHashMap<Key, Function>();
        if (this.getSupers().size() > 0) {
            for (BoxInterface _super : this.getSupers()) {
                methods.putAll(_super.getAllDefaultMethods());
            }
        }
        methods.putAll(this.getDefaultMethods());
        return methods;
    }
}

