/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.runnables;

import java.time.LocalDateTime;
import java.util.List;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.runnables.ITemplateRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public abstract class BoxTemplate
implements ITemplateRunnable {
    public void invoke(IBoxContext context) {
        BoxRuntime runtime = BoxRuntime.getInstance();
        boolean isInModule = context.getComponents().length > 0 && context.getComponents()[context.getComponents().length - 1].getAsKey(Key._NAME).equals(Key.module);
        context.pushTemplate(this);
        try {
            IStruct data = Struct.of(new Object[]{"context", context, "template", this, "templatePath", this.getRunnablePath()});
            runtime.announce("preTemplateInvoke", data);
            this._invoke(context);
            runtime.announce("postTemplateInvoke", data);
        }
        catch (AbortException e) {
            if (isInModule && (e.isTemplate().booleanValue() || e.isLoop().booleanValue() || e.isTag().booleanValue())) {
                throw e;
            }
            if (e.isLoop().booleanValue()) {
                throw new BoxValidationException("You cannot use the 'loop' method of the exit component outside of a custom tag.");
            }
            if (e.isRequest().booleanValue()) {
                context.flushBuffer(true);
                throw e;
            }
        }
        catch (Throwable e) {
            context.flushBuffer(true);
            throw e;
        }
        finally {
            context.popTemplate();
        }
    }

    @Override
    public abstract List<ImportDefinition> getImports();

    public abstract void _invoke(IBoxContext var1);

    @Override
    public abstract long getRunnableCompileVersion();

    @Override
    public abstract LocalDateTime getRunnableCompiledOn();

    @Override
    public abstract Object getRunnableAST();

    @Override
    public abstract ResolvedFilePath getRunnablePath();
}

