/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.runnables;

import java.nio.file.Path;
import java.util.Set;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.asmboxpiler.ASMBoxpiler;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.StaticClassBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.BoxScript;
import ortus.boxlang.runtime.runnables.BoxTemplate;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.types.exceptions.MissingIncludeException;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class RunnableLoader {
    private static RunnableLoader instance;
    private IBoxpiler boxpiler = JavaBoxpiler.getInstance();
    private static final Set<String> VALID_TEMPLATE_EXTENSIONS;

    private RunnableLoader() {
    }

    public static synchronized RunnableLoader getInstance() {
        if (instance == null) {
            instance = new RunnableLoader();
        }
        return instance;
    }

    public void selectBoxPiler(Class<?> clazz) {
        if (JavaBoxpiler.class.isAssignableFrom(clazz)) {
            this.boxpiler = JavaBoxpiler.getInstance();
        } else if (ASMBoxpiler.class.isAssignableFrom(clazz)) {
            this.boxpiler = ASMBoxpiler.getInstance();
        }
    }

    public IBoxpiler getBoxpiler() {
        return this.boxpiler;
    }

    public BoxTemplate loadTemplateAbsolute(IBoxContext context, ResolvedFilePath resolvedFilePath) {
        Path result = FileSystemUtil.pathExistsCaseInsensitive(resolvedFilePath.absolutePath());
        if (result == null) {
            throw new MissingIncludeException("The template path [" + resolvedFilePath.absolutePath().toString() + "] could not be found.", resolvedFilePath.absolutePath().toString());
        }
        if (!result.equals(resolvedFilePath.absolutePath())) {
            int lengthToUse = resolvedFilePath.relativePath() != null ? resolvedFilePath.relativePath().length() : resolvedFilePath.absolutePath().toString().length();
            resolvedFilePath = result.toString().length() <= lengthToUse ? ResolvedFilePath.of(resolvedFilePath.mappingName(), resolvedFilePath.mappingPath(), resolvedFilePath.absolutePath().toString().substring(result.toString().length()), result) : ResolvedFilePath.of(resolvedFilePath.mappingName(), resolvedFilePath.mappingPath(), resolvedFilePath.relativePath(), result);
        }
        String ext = "";
        String fileName = resolvedFilePath.absolutePath().getFileName().toString().toLowerCase();
        if (fileName.contains(".")) {
            ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        if (ext.equals("*") || VALID_TEMPLATE_EXTENSIONS.contains(ext)) {
            Class<IBoxRunnable> clazz = this.boxpiler.compileTemplate(resolvedFilePath);
            return (BoxTemplate)DynamicObject.of(clazz).invokeStatic(context, "getInstance", new Object[0]);
        }
        throw new BoxValidationException("The template path [" + resolvedFilePath.absolutePath().toString() + "] has an invalid extension to be executed [" + ext + "].");
    }

    public BoxTemplate loadTemplateRelative(IBoxContext context, String path) {
        return this.loadTemplateAbsolute(context, FileSystemUtil.expandPath(context, path));
    }

    public BoxScript loadSource(IBoxContext context, String source, BoxSourceType type) {
        Class<IBoxRunnable> clazz = this.boxpiler.compileScript(source, type);
        if (IClassRunnable.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Cannot define class in an ad-hoc script.");
        }
        return (BoxScript)DynamicObject.of(clazz).invokeStatic(context, "getInstance", new Object[0]);
    }

    public BoxScript loadSource(IBoxContext context, String source) {
        return this.loadSource(context, source, BoxSourceType.BOXSCRIPT);
    }

    public BoxScript loadStatement(IBoxContext context, String source, BoxSourceType type) {
        Class<IBoxRunnable> clazz = this.boxpiler.compileStatement(source, type);
        return (BoxScript)DynamicObject.of(clazz).invokeStatic(context, "getInstance", new Object[0]);
    }

    public Class<IBoxRunnable> loadClass(String source, IBoxContext context, BoxSourceType type) {
        Class<IBoxRunnable> clazz = this.boxpiler.compileClass(source, type);
        this.runStaticInitializer(clazz, context);
        return clazz;
    }

    public Class<IBoxRunnable> loadClass(ResolvedFilePath resolvedFilePath, IBoxContext context) {
        Class<IBoxRunnable> clazz = this.boxpiler.compileClass(resolvedFilePath);
        this.runStaticInitializer(clazz, context);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStaticInitializer(Class<IBoxRunnable> clazz, IBoxContext context) {
        DynamicObject boxClass;
        if (!clazz.isInterface() && IClassRunnable.class.isAssignableFrom(clazz) && !((Boolean)(boxClass = DynamicObject.of(clazz)).getField("staticInitialized").get()).booleanValue()) {
            Class<IBoxRunnable> clazz2 = clazz;
            synchronized (clazz2) {
                if (!((Boolean)boxClass.getField("staticInitialized").get()).booleanValue()) {
                    boxClass.invokeStatic(context, "staticInitializer", new StaticClassBoxContext(context, boxClass, BoxClassSupport.getStaticScope(context, boxClass)));
                    boxClass.setField("staticInitialized", true);
                }
            }
        }
    }

    static {
        VALID_TEMPLATE_EXTENSIONS = BoxRuntime.getInstance().getConfiguration().validTemplateExtensions;
    }
}

