/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scopes;

import java.util.HashSet;
import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.ScopeMeta;

public class BaseScope
extends Struct
implements IScope {
    private final Key scopeName;
    private final String lockName;
    private final Set<Key> finalKeys = new HashSet<Key>();
    public BoxMeta $bx;

    public BaseScope(Key scopeName) {
        this(scopeName, IStruct.TYPES.DEFAULT);
    }

    public BaseScope(Key scopeName, IStruct.TYPES type) {
        super(type);
        this.scopeName = scopeName;
        this.lockName = scopeName.getName() + new Object().hashCode();
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        if (key.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        return super.dereference(context, key, safe);
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new ScopeMeta(this, this.finalKeys);
        }
        return this.$bx;
    }

    @Override
    public Key getName() {
        return this.scopeName;
    }

    @Override
    public String getLockName() {
        return this.lockName;
    }

    @Override
    public Object assignFinal(IBoxContext context, Key name, Object value) {
        Object ret = this.assign(context, name, value);
        this.finalKeys.add(name);
        return ret;
    }

    @Override
    public Object put(Key key, Object value) {
        if (this.finalKeys.contains(key)) {
            Object object = super.get(key);
            if (object instanceof Function) {
                Function f = (Function)object;
                throw new BoxRuntimeException("Cannot override final function [" + key.getName() + "] in scope [" + this.scopeName.getName() + "]");
            }
            throw new BoxRuntimeException("Cannot reassign final key [" + key.getName() + "] in scope [" + this.scopeName.getName() + "]");
        }
        return super.put(key, value);
    }

    @Override
    public Object putIfAbsent(Key key, Object value) {
        if (this.finalKeys.contains(key)) {
            throw new BoxRuntimeException("Cannot reassign final key [" + key.getName() + "] in scope [" + this.scopeName.getName() + "]");
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public Object remove(Key key) {
        if (this.finalKeys.contains(key)) {
            throw new BoxRuntimeException("Cannot delete final key [" + key.getName() + "] in scope [" + this.scopeName.getName() + "]");
        }
        return super.remove(key);
    }
}

