/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scopes;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.ArgumentUtil;

public class ClassVariablesScope
extends VariablesScope {
    private final IClassRunnable thisClass;
    public static final Key name = Key.of("variables");

    public ClassVariablesScope(IClassRunnable thisClass) {
        this.thisClass = thisClass;
    }

    public IClassRunnable getThisClass() {
        return this.thisClass;
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = BoxRuntime.getInstance().getFunctionService().getMemberMethod(name, BoxLangType.STRUCT);
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof Function) {
                Function function = (Function)value;
                FunctionBoxContext fContext = Function.generateFunctionContext(function, context.getFunctionParentContext(), name, positionalArguments, this.getFunctionContextThisClassForInvoke(context), this.getFunctionContextThisInterfaceForInvoke());
                return function.invoke(fContext);
            }
            if (memberDescriptor == null) {
                throw new BoxRuntimeException("key '" + name.getName() + "' of type  '" + value.getClass().getName() + "'  is not a function ");
            }
        }
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        if (this.containsKey(Key.onMissingMethod) && !DynamicInteropService.hasMethod(this.getClass(), name.getName()).booleanValue()) {
            return this.thisClass.dereferenceAndInvoke(context, Key.onMissingMethod, new Object[]{name.getName(), ArgumentUtil.createArgumentsScope(context, positionalArguments)}, safe);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = BoxRuntime.getInstance().getFunctionService().getMemberMethod(name, BoxLangType.STRUCT);
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof Function) {
                Function function = (Function)value;
                FunctionBoxContext fContext = Function.generateFunctionContext(function, context.getFunctionParentContext(), name, namedArguments, this.getFunctionContextThisClassForInvoke(context), this.getFunctionContextThisInterfaceForInvoke());
                return function.invoke(fContext);
            }
            if (memberDescriptor == null) {
                throw new BoxRuntimeException("key '" + name.getName() + "' of type  '" + value.getClass().getName() + "'  is not a function ");
            }
        }
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        if (this.containsKey(Key.onMissingMethod) && !DynamicInteropService.hasMethod(this.getClass(), name.getName()).booleanValue()) {
            HashMap<Key, Object> args = new HashMap<Key, Object>();
            args.put(Key.missingMethodName, name.getName());
            args.put(Key.missingMethodArguments, ArgumentUtil.createArgumentsScope(context, namedArguments));
            return this.dereferenceAndInvoke(context, Key.onMissingMethod, args, safe);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
    }

    @Override
    public IClassRunnable getFunctionContextThisClassForInvoke(IBoxContext context) {
        return this.thisClass;
    }
}

