/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scopes;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Struct;

public class ScopeWrapper
extends BaseScope {
    IScope wrappedScope;

    public ScopeWrapper(IScope wrappedScope) {
        this(wrappedScope, (Map<Key, Object>)null);
    }

    public ScopeWrapper(IScope wrappedScope, Map<Key, Object> override) {
        super(Key.of("wrapper"));
        this.wrappedScope = wrappedScope;
        if (override != null) {
            super.putAll((Map<? extends Key, ? extends Object>)override);
        }
    }

    public IScope getWrapped() {
        return this.wrappedScope;
    }

    public void setWrapped(IScope wrappedScope) {
        this.wrappedScope = wrappedScope;
    }

    @Override
    public Key getName() {
        return this.wrappedScope.getName();
    }

    @Override
    public boolean containsKey(Object name) throws NullPointerException {
        if (super.containsKey(name)) {
            return true;
        }
        return this.wrappedScope.containsKey(name);
    }

    @Override
    public boolean containsKey(Key name) throws NullPointerException {
        if (super.containsKey(name)) {
            return true;
        }
        return this.wrappedScope.containsKey(name);
    }

    @Override
    public Object get(Object name) {
        Object result = super.getRaw((Key)name);
        if (result != null) {
            return Struct.unWrapNull(result);
        }
        return this.wrappedScope.get(name);
    }

    @Override
    public Object getRaw(Key key) {
        Object result = super.getRaw(key);
        if (result != null) {
            return result;
        }
        return this.wrappedScope.getRaw(key);
    }

    @Override
    public Object put(Key name, Object value) {
        if (super.containsKey(name)) {
            return super.put(name, value);
        }
        return this.wrappedScope.put(name, value);
    }

    @Override
    public List<String> getKeysAsStrings() {
        List<String> result = this.keySet().stream().map(Key::getName).collect(Collectors.toList());
        result.addAll(this.wrappedScope.keySet().stream().map(Key::getName).collect(Collectors.toList()));
        return result;
    }

    @Override
    public List<Key> getKeys() {
        List<Key> result = this.keySet().stream().collect(Collectors.toList());
        result.addAll(this.wrappedScope.keySet().stream().collect(Collectors.toList()));
        return result;
    }
}

