/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scopes;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableArray;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableStruct;
import ortus.boxlang.runtime.util.NetworkUtil;

public class ServerScope
extends BaseScope {
    private static final Logger logger = LoggerFactory.getLogger(ServerScope.class);
    private static final List<Key> unmodifiableKeys = List.of(Key.coldfusion, Key.java, Key.os, Key.separator, Key.system);
    private boolean initialized = false;
    public static final Key name = Key.server;

    public ServerScope() {
        super(name);
        this.seedScope();
    }

    @Override
    public IScope initialize() {
        BoxRuntime.getInstance().announce(BoxEvent.ON_SERVER_SCOPE_CREATION, Struct.of(new Object[]{"scope", this, "name", name}));
        this.initialized = true;
        logger.debug("Server Scope Constructed and Initialized");
        return this;
    }

    @Override
    public Object put(Key key, Object value) {
        if (this.initialized && unmodifiableKeys.contains(key)) {
            throw new BoxRuntimeException(String.format("Cannot modify key %s in server scope", key));
        }
        return super.put(key, value);
    }

    private void seedScope() {
        BoxRuntime runtime = BoxRuntime.getInstance();
        IStruct versionInfo = runtime.getVersionInfo();
        this.put(Key.boxlang, (Object)UnmodifiableStruct.of(new Object[]{"buildDate", versionInfo.get("buildDate"), "boxlangId", versionInfo.get("boxlangId"), "codename", versionInfo.get("codename"), "cliMode", runtime.inCLIMode(), "debugMode", runtime.inDebugMode(), "jarMode", runtime.inJarMode(), "runtimeHome", runtime.getRuntimeHome().toString(), "version", versionInfo.get("version")}));
        this.put(Key.os, (Object)UnmodifiableStruct.of(new Object[]{"additionalinformation", "", "arch", System.getProperty("os.arch", ""), "archModel", System.getProperty("os.arch", ""), "hostname", NetworkUtil.getLocalHostname(), "ipAddress", NetworkUtil.getLocalIPAddress(), "macAddress", NetworkUtil.getLocalMacAddress(), "name", System.getProperty("os.name"), "version", System.getProperty("os.version")}));
        this.put(Key.separator, (Object)UnmodifiableStruct.of(new Object[]{"path", System.getProperty("path.separator", ""), "file", System.getProperty("file.separator", ""), "line", System.getProperty("line.separator", "")}));
        this.put(Key.cli, (Object)UnmodifiableStruct.of(new Object[]{"executionPath", System.getProperty("user.dir", ""), "command", System.getProperty("sun.java.command", ""), "args", runtime.inCLIMode() ? new UnmodifiableArray(runtime.getCliOptions().cliArgs()) : "", "parsed", runtime.inCLIMode() ? new UnmodifiableStruct(runtime.getCliOptions().parseArguments()) : new UnmodifiableStruct()}));
        Runtime javaRuntime = Runtime.getRuntime();
        this.put(Key.java, (Object)UnmodifiableStruct.of(new Object[]{"archModel", System.getProperty("os.arch", ""), "executionPath", System.getProperty("user.dir", ""), "freeMemory", javaRuntime.freeMemory(), "maxMemory", javaRuntime.maxMemory(), "totalMemory", javaRuntime.totalMemory(), "vendor", System.getProperty("java.vendor", ""), "version", System.getProperty("java.version", "")}));
        UnmodifiableStruct env = UnmodifiableStruct.fromMap(System.getenv());
        UnmodifiableStruct props = UnmodifiableStruct.fromMap(System.getProperties());
        this.put(Key.system, (Object)UnmodifiableStruct.of(new Object[]{"environment", env, "properties", props}));
    }
}

