/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scripting;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.RequestScope;
import ortus.boxlang.runtime.scopes.ServerScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.scripting.BoxScopeBindings;

public class BoxScriptingContext
implements ScriptContext {
    private Bindings engineScope;
    private Bindings globalScope;
    private Bindings requestScope;
    private Writer errorWriter;
    private Writer writer;
    private Reader reader;
    public static final int REQUEST_SCOPE = 999;

    public BoxScriptingContext(IBoxContext boxContext) {
        this.engineScope = new BoxScopeBindings(boxContext.getScopeNearby(VariablesScope.name));
        this.requestScope = new BoxScopeBindings(boxContext.getScopeNearby(RequestScope.name));
        this.globalScope = new BoxScopeBindings(boxContext.getScopeNearby(ServerScope.name));
        this.errorWriter = new PrintWriter(System.err);
        this.writer = new PrintWriter(System.out);
        this.reader = new InputStreamReader(System.in);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                this.engineScope.putAll(bindings);
                break;
            }
            case 200: {
                this.globalScope.putAll(bindings);
                break;
            }
            case 999: {
                this.requestScope.putAll(bindings);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope value [" + scope + "]. Valid scopes are ENGINE_SCOPE, GLOBAL_SCOPE, and REQUEST_SCOPE");
            }
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        if (scope == 100) {
            return this.engineScope;
        }
        if (scope == 200) {
            return this.globalScope;
        }
        if (scope == 999) {
            return this.requestScope;
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.getBindings(scope).put(name, value);
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getBindings(scope).get(name);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        return this.getBindings(scope).remove(name);
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.engineScope.get(name);
        if (value == null && (value = this.requestScope.get(name)) == null) {
            value = this.globalScope.get(name);
        }
        return value;
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.engineScope.containsKey(name)) {
            return 100;
        }
        if (this.requestScope.containsKey(name)) {
            return 999;
        }
        if (this.globalScope.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return Arrays.asList(100, 200, 999);
    }
}

