/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scripting;

import java.io.Reader;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyService;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.RunnableLoader;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scripting.BoxCompiledScript;
import ortus.boxlang.runtime.scripting.BoxScriptingContext;
import ortus.boxlang.runtime.scripting.BoxScriptingFactory;
import ortus.boxlang.runtime.scripting.JSRScriptingRequestBoxContext;

public class BoxScriptingEngine
implements ScriptEngine,
Compilable,
Invocable {
    private JSRScriptingRequestBoxContext boxContext;
    private BoxScriptingFactory boxScriptingFactory;
    private BoxRuntime boxRuntime;
    private ScriptContext scriptContext;

    public BoxScriptingEngine(BoxScriptingFactory boxScriptingFactory, Boolean debug) {
        this.boxScriptingFactory = boxScriptingFactory;
        this.boxRuntime = BoxRuntime.getInstance(debug);
        this.boxContext = new JSRScriptingRequestBoxContext(this.boxRuntime.getRuntimeContext());
        this.scriptContext = new BoxScriptingContext(this.boxContext);
        this.boxContext.setJSRScriptingContext(this.scriptContext);
    }

    public BoxScriptingEngine(BoxScriptingFactory boxScriptingFactory) {
        this(boxScriptingFactory, false);
    }

    public BoxRuntime getRuntime() {
        return this.boxRuntime;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        this.scriptContext = context;
        return this.eval(script);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        this.scriptContext = context;
        return this.eval(reader);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader.toString());
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        this.setBindings(n, 100);
        return this.eval(script);
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        this.setBindings(n, 100);
        return this.eval(reader);
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.boxRuntime.executeStatement(script, (IBoxContext)this.boxContext);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public Bindings creatBindings(Map<String, Object> m) {
        return new SimpleBindings(m);
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    public Bindings getBindings() {
        return this.scriptContext.getBindings(100);
    }

    public Bindings getRequestBindings() {
        return this.scriptContext.getBindings(999);
    }

    public Bindings getServerBindings() {
        return this.scriptContext.getBindings(200);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.scriptContext.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.scriptContext.setBindings(bindings, scope);
    }

    @Override
    public ScriptContext getContext() {
        return this.scriptContext;
    }

    @Override
    public void setContext(ScriptContext context) {
        this.scriptContext = context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.boxScriptingFactory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new BoxCompiledScript(this, RunnableLoader.getInstance().loadStatement(BoxRuntime.getInstance().getRuntimeContext(), script, BoxSourceType.BOXSCRIPT));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        return new BoxCompiledScript(this, RunnableLoader.getInstance().loadStatement(BoxRuntime.getInstance().getRuntimeContext(), script.toString(), BoxSourceType.BOXSCRIPT));
    }

    public JSRScriptingRequestBoxContext getBoxContext() {
        return this.boxContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new ScriptException("Cannot invoke method on null object");
        }
        RequestBoxContext.setCurrent(this.getBoxContext().getParentOfType(RequestBoxContext.class));
        try {
            Object object = Referencer.getAndInvoke((IBoxContext)this.getBoxContext(), thiz, Key.of(name), args, (Boolean)false);
            return object;
        }
        finally {
            RequestBoxContext.removeCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        RequestBoxContext.setCurrent(this.boxContext.getParentOfType(RequestBoxContext.class));
        try {
            Object object = this.boxContext.invokeFunction(Key.of(name), args);
            return object;
        }
        finally {
            RequestBoxContext.removeCurrent();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return this.buildGenericProxy(this.getBindings(100), clasz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz instanceof IClassRunnable) {
            IClassRunnable castedRunnable = (IClassRunnable)thiz;
            return (T)InterfaceProxyService.buildGenericProxy((IBoxContext)this.getBoxContext(), (Object)castedRunnable, null, new Class[]{clasz}, clasz.getClassLoader());
        }
        if (thiz instanceof Map) {
            Map map = (Map)thiz;
            return this.buildGenericProxy(map, clasz);
        }
        return null;
    }

    private <T> T buildGenericProxy(Map<?, ?> map, Class<T> interfaceClass) {
        IClassRunnable dummyBoxClass = (IClassRunnable)DynamicObject.of(RunnableLoader.getInstance().loadClass("class {}\n", this.getBoxContext(), BoxSourceType.BOXSCRIPT)).invokeConstructor(this.getBoxContext()).getTargetInstance();
        dummyBoxClass.getVariablesScope().addAll(map);
        dummyBoxClass.getThisScope().addAll(map);
        return (T)InterfaceProxyService.buildGenericProxy((IBoxContext)this.getBoxContext(), (Object)dummyBoxClass, null, new Class[]{interfaceClass}, interfaceClass.getClassLoader());
    }
}

