/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.scripting;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scripting.BoxScriptingEngine;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class BoxScriptingFactory
implements ScriptEngineFactory {
    private IStruct versionInfo;

    private IStruct getVersionInfo() {
        if (this.versionInfo == null) {
            Properties properties = new Properties();
            try (InputStream inputStream = BoxScriptingFactory.class.getResourceAsStream("/META-INF/boxlang/version.properties");){
                properties.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.versionInfo = Struct.fromMap(properties);
        }
        return this.versionInfo;
    }

    @Override
    public String getEngineName() {
        return "BoxLang";
    }

    @Override
    public String getEngineVersion() {
        return this.getVersionInfo().getAsString(Key.version);
    }

    @Override
    public String getLanguageName() {
        return "BoxLang";
    }

    @Override
    public String getLanguageVersion() {
        return this.getVersionInfo().getAsString(Key.version);
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj + "." + m + "(");
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            sb.append("'" + args[i].replace("'", "''") + "'");
            if (i >= len - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "writeoutput( '" + toDisplay.replace("'", "''") + "' )";
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        int len = statements.length;
        for (int i = 0; i < len; ++i) {
            sb.append(statements[i]).append(";\n");
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new BoxScriptingEngine(this);
    }

    public BoxScriptingEngine getScriptEngine(Boolean debug) {
        return new BoxScriptingEngine(this, debug);
    }

    @Override
    public List<String> getExtensions() {
        return new ArrayList<String>(BoxRuntime.getInstance().getConfiguration().getValidExtensions());
    }

    @Override
    public List<String> getMimeTypes() {
        return List.of();
    }

    @Override
    public List<String> getNames() {
        return List.of("BoxLang", "BL", "BX");
    }

    @Override
    public Object getParameter(String key) {
        if (key.equalsIgnoreCase("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equalsIgnoreCase("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equalsIgnoreCase("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equalsIgnoreCase("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equalsIgnoreCase("javax.script.name")) {
            return this.getNames().get(0);
        }
        if (key.equalsIgnoreCase("THREADING")) {
            return "THREAD-ISOLATED";
        }
        return null;
    }
}

