/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.application.Application;
import ortus.boxlang.runtime.application.ApplicationClassListener;
import ortus.boxlang.runtime.application.ApplicationDefaultListener;
import ortus.boxlang.runtime.application.ApplicationTemplateListener;
import ortus.boxlang.runtime.application.BaseApplicationListener;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.RunnableLoader;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class ApplicationService
extends BaseService {
    private Map<Key, Application> applications = new ConcurrentHashMap<Key, Application>();
    private Set<String> applicationDescriptorClassExtensions;
    private Set<String> applicationDescriptorExtensions;
    private static final Logger logger = LoggerFactory.getLogger(ApplicationService.class);

    public ApplicationService(BoxRuntime runtime) {
        super(runtime, Key.applicationService);
    }

    public Application getApplication(Key name) {
        Application thisApplication = this.applications.computeIfAbsent(name, k -> new Application(name));
        logger.trace("ApplicationService.getApplication() - {}", (Object)name);
        return thisApplication;
    }

    public void removeApplication(Key name) {
        logger.trace("ApplicationService.removeApplication() - {}", (Object)name);
        this.applications.remove(name);
    }

    public void shutdownApplication(Key name) {
        Application thisApp = this.applications.get(name);
        if (thisApp != null) {
            thisApp.shutdown(false);
            this.applications.remove(name);
        }
        logger.trace("ApplicationService.shutdownApplication() - {}", (Object)name);
    }

    public boolean hasApplication(Key name) {
        return this.applications.containsKey(name);
    }

    public String[] getApplicationNames() {
        return (String[])this.applications.keySet().stream().sorted().map(Key::getName).toArray(String[]::new);
    }

    @Override
    public void onStartup() {
        this.applicationDescriptorClassExtensions = BoxRuntime.getInstance().getConfiguration().validClassExtensions;
        this.applicationDescriptorExtensions = BoxRuntime.getInstance().getConfiguration().validTemplateExtensions;
    }

    @Override
    public void onShutdown(Boolean force) {
        this.applications.values().parallelStream().forEach(app -> app.shutdown(force));
    }

    public BaseApplicationListener createApplicationListener(RequestBoxContext context, URI template) {
        BaseApplicationListener listener;
        ApplicationDescriptorSearch searchResult = null;
        if (template != null) {
            String directoryOfTemplate = null;
            String packagePath = "";
            String rootMapping = context.getConfig().getAsStruct(Key.mappings).getAsString(Key._slash);
            if (template.isAbsolute()) {
                directoryOfTemplate = new File(template).getParent();
                searchResult = this.fileLookup(directoryOfTemplate);
            } else {
                directoryOfTemplate = new File(template.toString()).getParent();
                while (directoryOfTemplate != null) {
                    searchResult = directoryOfTemplate.equals(File.separator) ? this.fileLookup(rootMapping) : this.fileLookup(Paths.get(rootMapping, directoryOfTemplate).toString());
                    if (searchResult != null) {
                        packagePath = directoryOfTemplate.replace(File.separator, ".");
                        if (packagePath.endsWith(".")) {
                            packagePath = packagePath.substring(0, packagePath.length() - 1);
                        }
                        if (!packagePath.startsWith(".")) break;
                        packagePath = packagePath.substring(1);
                        break;
                    }
                    directoryOfTemplate = new File(directoryOfTemplate).getParent();
                }
            }
            listener = searchResult != null ? (searchResult.type() == ApplicationDescriptorType.CLASS ? new ApplicationClassListener((IClassRunnable)DynamicObject.of(RunnableLoader.getInstance().loadClass(ResolvedFilePath.of("/", rootMapping, packagePath.replace(".", File.separator) + File.separator + String.valueOf(searchResult.path().getFileName()), searchResult.path()), context)).invokeConstructor((IBoxContext)context, Key.noInit).getTargetInstance(), context) : new ApplicationTemplateListener(RunnableLoader.getInstance().loadTemplateAbsolute(context, ResolvedFilePath.of("/", rootMapping, packagePath.replace(".", File.separator) + File.separator + String.valueOf(searchResult.path().getFileName()), searchResult.path())), context)) : new ApplicationDefaultListener(context);
        } else {
            listener = new ApplicationDefaultListener(context);
        }
        this.announce(BoxEvent.BEFORE_APPLICATION_LISTENER_LOAD, Struct.of(new Object[]{"listener", listener, "context", context, "template", template}));
        listener.defineApplication();
        this.announce(BoxEvent.AFTER_APPLICATION_LISTENER_LOAD, Struct.of(new Object[]{"listener", listener, "context", context, "template", template}));
        return listener;
    }

    private ApplicationDescriptorSearch fileLookup(String path) {
        Path descriptorPath;
        for (String extension : this.applicationDescriptorClassExtensions) {
            descriptorPath = Paths.get(path, "Application." + extension);
            if (!descriptorPath.toFile().exists()) continue;
            return new ApplicationDescriptorSearch(descriptorPath, ApplicationDescriptorType.CLASS);
        }
        for (String extension : this.applicationDescriptorExtensions) {
            descriptorPath = Paths.get(path, "Application." + extension);
            if (!descriptorPath.toFile().exists()) continue;
            return new ApplicationDescriptorSearch(descriptorPath, ApplicationDescriptorType.TEMPLATE);
        }
        return null;
    }

    private record ApplicationDescriptorSearch(Path path, ApplicationDescriptorType type) {
    }

    private static enum ApplicationDescriptorType {
        CLASS,
        TEMPLATE;

    }
}

