/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.async.executors.BoxScheduledExecutor;
import ortus.boxlang.runtime.async.executors.ExecutorRecord;
import ortus.boxlang.runtime.config.segments.ExecutorConfig;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;

public class AsyncService
extends BaseService {
    public static final int DEFAULT_MAX_THREADS = 20;
    public static final Long DEFAULT_TIMEOUT = 30L;
    private Map<String, ExecutorRecord> executors = new ConcurrentHashMap<String, ExecutorRecord>();
    private static final Logger logger = LoggerFactory.getLogger(AsyncService.class);

    public AsyncService(BoxRuntime runtime) {
        super(runtime, Key.asyncService);
    }

    @Override
    public void onStartup() {
        this.runtime.getConfiguration().executors.entrySet().forEach(entry -> {
            ExecutorConfig thisConfig = (ExecutorConfig)entry.getValue();
            this.newExecutor(thisConfig.name, ExecutorType.valueOf(thisConfig.type), thisConfig.maxThreads);
            logger.debug("+ Registered executor [{}] with type [{}] and max threads [{}]", thisConfig.name, thisConfig.type, thisConfig.maxThreads);
        });
        logger.info("AsyncService.onStartup()");
    }

    @Override
    public void onShutdown(Boolean force) {
        logger.info("AsyncService.onShutdown()");
        this.shutdownAllExecutors(force, DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    public Map<String, ExecutorRecord> getExecutors() {
        return this.executors;
    }

    public ExecutorRecord newExecutor(String name, ExecutorType type) {
        return this.newExecutor(name, type, 20);
    }

    public ExecutorRecord newExecutor(String name, ExecutorType type, int maxThreads) {
        this.executors.computeIfAbsent(name, key -> AsyncService.buildExecutor(name, type, maxThreads));
        return this.executors.get(name);
    }

    public Boolean hasExecutor(String name) {
        return this.executors.containsKey(name);
    }

    public ExecutorRecord getExecutor(String name) {
        if (!this.hasExecutor(name).booleanValue()) {
            throw new KeyNotFoundException("Executor [" + name + "] does not exist. Valid executors are " + this.executors.keySet().toString());
        }
        return this.executors.get(name);
    }

    public AsyncService deleteExecutor(String name) {
        ExecutorRecord targetExecutor;
        if (this.hasExecutor(name).booleanValue() && (targetExecutor = this.executors.remove(name)).executor().isShutdown()) {
            targetExecutor.executor().shutdownNow();
        }
        return this;
    }

    public AsyncService shutdownExecutor(String name, Boolean force, Long timeout, TimeUnit unit) {
        timeout = timeout == null ? DEFAULT_TIMEOUT : timeout;
        TimeUnit timeUnit = unit = unit == null ? TimeUnit.SECONDS : unit;
        if (this.hasExecutor(name).booleanValue()) {
            logger.debug("+ Shutting down executor ({}), with force ({}) and timeout ({})...", name, force, timeout);
            this.getTimerUtil().start("shutdown-executor-" + name);
            if (Boolean.TRUE.equals(force)) {
                this.getExecutor(name).executor().shutdownNow();
            } else {
                this.getExecutor(name).shutdownAndAwaitTermination(timeout, unit);
            }
            logger.debug("+ Shutdown executor ({}) in [{}]", (Object)name, (Object)this.getTimerUtil().stop("shutdown-executor-" + name));
        }
        return this;
    }

    public AsyncService shutdownAllExecutors() {
        return this.shutdownAllExecutors(false, DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    public AsyncService shutdownAllExecutors(Boolean force, Long timeout, TimeUnit unit) {
        this.getTimerUtil().start("shutdownAllExecutors");
        logger.debug("+ Starting to shutdown all executors...");
        this.executors.keySet().parallelStream().forEach(executorName -> this.shutdownExecutor((String)executorName, force, timeout, unit));
        logger.debug("+ Shutdown all async executor services in [{}]", (Object)this.getTimerUtil().stop("shutdownAllExecutors"));
        return this;
    }

    public List<String> getExecutorNames() {
        return this.executors.keySet().stream().collect(Collectors.toList());
    }

    public IStruct getExecutorStatusMap() {
        return new Struct(this.executors.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ExecutorRecord)entry.getValue()).getStats())));
    }

    public IStruct getExecutorStatusMap(String name) {
        return this.getExecutor(name).getStats();
    }

    public ExecutorRecord newCachedExecutor(String name) {
        return this.newExecutor(name, ExecutorType.CACHED);
    }

    public ExecutorRecord newFixedExecutor(String name, Integer maxThreads) {
        return this.newExecutor(name, ExecutorType.FIXED, maxThreads == null ? 20 : maxThreads);
    }

    public ExecutorRecord newSingleExecutor(String name) {
        return this.newExecutor(name, ExecutorType.SINGLE);
    }

    public ExecutorRecord newScheduledExecutor(String name, Integer maxThreads) {
        return this.newExecutor(name, ExecutorType.SCHEDULED, maxThreads == null ? 20 : maxThreads);
    }

    public ExecutorRecord newScheduledExecutor(String name) {
        return this.newExecutor(name, ExecutorType.SCHEDULED, 20);
    }

    public ExecutorRecord newWorkStealingExecutor(String name, Integer maxThreads) {
        return this.newExecutor(name, ExecutorType.WORK_STEALING, maxThreads == null ? 20 : maxThreads);
    }

    public ExecutorRecord newVirtualExecutor(String name) {
        return this.newExecutor(name, ExecutorType.VIRTUAL);
    }

    public static ExecutorRecord buildExecutor(String name, ExecutorType type, Integer maxThreads) {
        ExecutorService executor = null;
        switch (type.ordinal()) {
            case 0: {
                executor = Executors.newCachedThreadPool();
                break;
            }
            case 1: {
                executor = Executors.newFixedThreadPool(maxThreads);
                break;
            }
            case 3: {
                executor = new BoxScheduledExecutor(maxThreads);
                break;
            }
            case 4: {
                executor = Executors.newSingleThreadExecutor();
                break;
            }
            case 6: {
                executor = Executors.newWorkStealingPool(maxThreads);
                break;
            }
            case 2: {
                executor = maxThreads != null ? new ForkJoinPool(maxThreads) : ForkJoinPool.commonPool();
                break;
            }
            case 5: {
                executor = Executors.newVirtualThreadPerTaskExecutor();
                break;
            }
            default: {
                executor = null;
            }
        }
        return new ExecutorRecord(executor, name, type, maxThreads);
    }

    public static enum ExecutorType {
        CACHED,
        FIXED,
        FORK_JOIN,
        SCHEDULED,
        SINGLE,
        VIRTUAL,
        WORK_STEALING;

    }
}

