/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.async.executors.ExecutorRecord;
import ortus.boxlang.runtime.cache.providers.BoxCacheProvider;
import ortus.boxlang.runtime.cache.providers.CoreProviderType;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.config.segments.CacheConfig;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;

public class CacheService
extends BaseService {
    public static final Class<CoreProviderType> CORE_TYPES = CoreProviderType.class;
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    private final AsyncService asyncService;
    private final InterceptorService interceptorService;
    private final ExecutorRecord executor;
    private final Map<Key, ICacheProvider> caches = new ConcurrentHashMap<Key, ICacheProvider>();
    private final Map<Key, Class<? extends ICacheProvider>> providers = new ConcurrentHashMap<Key, Class<? extends ICacheProvider>>();

    public CacheService(BoxRuntime runtime) {
        super(runtime, Key.cacheService);
        this.asyncService = runtime.getAsyncService();
        this.interceptorService = runtime.getInterceptorService();
        this.executor = this.asyncService.newScheduledExecutor("cacheservice-tasks", 20);
    }

    public ExecutorRecord getTaskScheduler() {
        return this.executor;
    }

    @Override
    public void onStartup() {
        BoxRuntime.timerUtil.start("cacheservice-startup");
        logger.debug("+ Starting up Cache Service...");
        this.createDefaultCache(Key._DEFAULT, this.getRuntime().getConfiguration().defaultCache);
        this.runtime.getConfiguration().caches.entrySet().parallelStream().forEach(entry -> {
            CacheConfig config = (CacheConfig)entry.getValue();
            this.createCache((Key)entry.getKey(), config.provider, config.properties);
        });
        this.announce(BoxEvent.AFTER_CACHE_SERVICE_STARTUP, Struct.of(new Object[]{"cacheService", this}));
        logger.info("+ Cache Service started in [{}] ms", (Object)BoxRuntime.timerUtil.stopAndGetMillis("cacheservice-startup"));
    }

    @Override
    public void onShutdown(Boolean force) {
        BoxRuntime.timerUtil.start("cacheservice-shutdown");
        logger.debug("+ Shutting down the Cache Service...");
        this.announce(BoxEvent.BEFORE_CACHE_SERVICE_SHUTDOWN, Struct.of(new Object[]{"cacheService", this}));
        this.caches.keySet().parallelStream().forEach(this::shutdownCache);
        this.announce(BoxEvent.AFTER_CACHE_SERVICE_SHUTDOWN, Struct.of(new Object[]{"cacheService", this}));
        logger.debug("+ Cache Service shut down in [{}] ms", (Object)BoxRuntime.timerUtil.stopAndGetMillis("cacheservice-shutdown"));
    }

    public synchronized void shutdownCache(Key name) {
        if (!this.caches.containsKey(name)) {
            return;
        }
        logger.debug("Shutting down cache [{}]", (Object)name);
        ICacheProvider cache = this.caches.get(name);
        try {
            this.announce(BoxEvent.BEFORE_CACHE_SHUTDOWN, Struct.of(new Object[]{"cacheService", this, "cache", cache}));
            cache.shutdown();
            this.announce(BoxEvent.AFTER_CACHE_SHUTDOWN, Struct.of(new Object[]{"cacheService", this, "cache", cache}));
            logger.debug("Cache [{}] shut down succesfully", (Object)name);
        }
        catch (Exception e) {
            logger.error("Error shutting down cache [{}]: {}", (Object)name, (Object)e.getMessage());
        }
        this.announce(BoxEvent.BEFORE_CACHE_REMOVAL, Struct.of(new Object[]{"cacheService", this, "cache", cache}));
        this.caches.remove(name);
        this.announce(BoxEvent.AFTER_CACHE_REMOVAL, Struct.of(new Object[]{"cacheService", this, "cacheName", name}));
    }

    public ICacheProvider getCache(String name) {
        return this.getCache(Key.of(name));
    }

    public ICacheProvider getCache(Key name) {
        ICacheProvider results = this.caches.get(name);
        if (results == null) {
            throw new BoxRuntimeException("Cache [" + String.valueOf(name) + "] does not exist. Valid caches are: " + String.valueOf(this.getRegisteredCaches()));
        }
        return results;
    }

    public ICacheProvider getDefaultCache() {
        return this.getCache(Key._DEFAULT);
    }

    public boolean hasCache(String name) {
        return this.hasCache(Key.of(name));
    }

    public boolean hasCache(Key name) {
        return this.caches.containsKey(name);
    }

    public CacheService replaceCache(String name, ICacheProvider newProvider) {
        return this.replaceCache(Key.of(name), newProvider);
    }

    public CacheService replaceCache(Key name, ICacheProvider newProvider) {
        if (this.hasCache(name)) {
            this.announce(BoxEvent.BEFORE_CACHE_REPLACEMENT, Struct.of(new Object[]{"cacheService", this, "oldCache", this.getCache(name), "newCache", newProvider}));
            this.shutdownCache(name);
        }
        this.registerCache(newProvider);
        return this;
    }

    public ICacheProvider registerCache(ICacheProvider provider) {
        if (this.hasCache(provider.getName())) {
            throw new BoxRuntimeException("Cache [" + String.valueOf(provider.getName()) + "] already exists.");
        }
        this.caches.put(provider.getName(), provider);
        this.announce(BoxEvent.AFTER_CACHE_REGISTRATION, Struct.of(new Object[]{"cacheService", this, "cache", provider}));
        return provider;
    }

    public ICacheProvider createDefaultCache(String name) {
        return this.createDefaultCache(Key.of(name));
    }

    public ICacheProvider createDefaultCache(Key name) {
        return this.createDefaultCache(name, new CacheConfig(name));
    }

    public ICacheProvider createDefaultCache(String name, CacheConfig config) {
        return this.createDefaultCache(Key.of(name), config);
    }

    public ICacheProvider createDefaultCache(Key name, CacheConfig config) {
        if (this.hasCache(name)) {
            throw new BoxRuntimeException("Cache [" + String.valueOf(name) + "] already exists.");
        }
        ICacheProvider cache = new BoxCacheProvider().setName(name).configure(this, config);
        this.registerCache(cache);
        return cache;
    }

    public Array getRegisteredCaches() {
        return this.caches.keySet().stream().map(Key::getName).collect(BLCollector.toArray());
    }

    public ICacheProvider createCache(String name, String provider, IStruct properties) {
        return this.createCache(Key.of(name), Key.of(provider), properties);
    }

    public ICacheProvider createCache(Key name, Key provider, IStruct properties) {
        if (this.hasCache(name)) {
            throw new BoxRuntimeException("Cache [" + String.valueOf(name) + "] already exists.");
        }
        ICacheProvider cache = this.buildCacheProvider(provider).setName(name).configure(this, new CacheConfig(name, provider, properties));
        return this.registerCache(cache);
    }

    public Array getRegisteredProviders() {
        return this.providers.keySet().stream().map(Key::getName).collect(BLCollector.toArray());
    }

    public boolean hasProvider(String provider) {
        return this.hasProvider(Key.of(provider));
    }

    public boolean hasProvider(Key provider) {
        return this.providers.containsKey(provider);
    }

    public Class<? extends ICacheProvider> getProvider(String provider) {
        return this.getProvider(Key.of(provider));
    }

    public Class<? extends ICacheProvider> getProvider(Key provider) {
        Class<? extends ICacheProvider> results = this.providers.get(provider);
        if (results == null) {
            throw new BoxRuntimeException("Cache Provider [" + String.valueOf(provider) + "] does not exist. Valid providers are: " + String.valueOf(this.getRegisteredProviders()));
        }
        return results;
    }

    public CacheService registerProvider(String name, Class<? extends ICacheProvider> provider) {
        return this.registerProvider(Key.of(name), provider);
    }

    public CacheService registerProvider(Key name, Class<? extends ICacheProvider> provider) {
        if (this.providers.containsKey(name)) {
            throw new BoxRuntimeException("Custom Provider [" + String.valueOf(name) + "] already exists.");
        }
        this.providers.put(name, provider);
        return this;
    }

    public boolean removeProvider(String name) {
        return this.removeProvider(Key.of(name));
    }

    public boolean removeProvider(Key name) {
        return this.providers.remove(name) != null;
    }

    public void removeAllCaches() {
        this.caches.keySet().parallelStream().forEach(this::shutdownCache);
    }

    public void clearAllCaches() {
        this.caches.values().parallelStream().forEach(rec$ -> ((ICacheProvider)rec$).clear(new String[0]));
    }

    public void reapAllCaches() {
        this.caches.values().parallelStream().forEach(ICacheProvider::reap);
    }

    private ICacheProvider buildCacheProvider(Key provider) {
        if (CoreProviderType.isCore(provider)) {
            return CoreProviderType.getValueByKey(provider).buildProvider();
        }
        if (this.hasProvider(provider)) {
            try {
                return this.getProvider(provider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BoxRuntimeException("Error building cache provider [" + String.valueOf(provider) + "]: " + e.getMessage());
            }
        }
        throw new BoxRuntimeException("No cache provider with the name [" + String.valueOf(provider) + "] is registered. Available providers are: " + String.valueOf(this.getRegisteredProviders()));
    }
}

