/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.io.IOException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.components.ComponentDescriptor;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class ComponentService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(ComponentService.class);
    private Map<Key, ComponentDescriptor> componentRegistry = new ConcurrentHashMap<Key, ComponentDescriptor>();

    public ComponentService(BoxRuntime runtime) {
        super(runtime, Key.componentService);
    }

    @Override
    public void onStartup() {
        String timerLabel = "componentservice-loadcomponentregistry";
        BoxRuntime.timerUtil.start(timerLabel);
        try {
            this.loadComponentRegistry();
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Cannot load components", e);
        }
        logger.info("+ Component Service: Registered [{}] components in [{}] ms", (Object)this.getComponentCount(), (Object)BoxRuntime.timerUtil.stopAndGetMillis(timerLabel));
    }

    @Override
    public void onShutdown(Boolean force) {
        logger.debug("+ Component Service: Shutting down");
    }

    public long getComponentCount() {
        return this.componentRegistry.size();
    }

    public String[] getComponentNames() {
        return (String[])this.componentRegistry.keySet().stream().sorted().map(Key::getName).toArray(String[]::new);
    }

    public Boolean hasComponent(String name) {
        return this.hasComponent(Key.of(name));
    }

    public Boolean hasComponent(Key name) {
        return this.componentRegistry.containsKey(name);
    }

    public ComponentDescriptor getComponent(String name) {
        return this.getComponent(Key.of(name));
    }

    public ComponentDescriptor getComponent(Key name) {
        return this.componentRegistry.get(name);
    }

    public void registerComponent(ComponentDescriptor descriptor, Key name, Boolean force) {
        if (this.hasComponent(descriptor.name).booleanValue() && !force.booleanValue()) {
            throw new BoxRuntimeException(" component " + name.getName() + " already exists");
        }
        this.componentRegistry.put(name, descriptor);
    }

    public void registerComponent(ComponentDescriptor descriptor, Boolean force) {
        this.registerComponent(descriptor, descriptor.name, force);
    }

    public void unregisterComponent(Key name) {
        this.componentRegistry.remove(name);
    }

    public void loadComponentRegistry() throws IOException {
        ((Stream)ServiceLoader.load(Component.class, BoxRuntime.class.getClassLoader()).stream().parallel()).map(ServiceLoader.Provider::type).forEach(targetClass -> this.registerComponent((Class<?>)targetClass, null, null));
    }

    public void registerComponent(Class<?> componentClass, Component component, String module) {
        BoxComponent[] commponentAnnotations;
        if (componentClass == null && component != null) {
            componentClass = component.getClass();
        } else if (componentClass == null) {
            throw new BoxRuntimeException("Cannot register component because no component class or component was provided");
        }
        Key customName = Key.of("");
        String alias = "";
        boolean allowsBody = false;
        boolean requiresBody = false;
        Key className = Key.of(componentClass.getSimpleName());
        for (BoxComponent annotation : commponentAnnotations = (BoxComponent[])componentClass.getAnnotationsByType(BoxComponent.class)) {
            customName = annotation.name().length() > 0 ? Key.of(annotation.name()) : className;
            allowsBody = annotation.allowsBody();
            requiresBody = annotation.requiresBody();
            alias = annotation.alias();
            ComponentDescriptor descriptor = new ComponentDescriptor(customName, componentClass, module, null, component, allowsBody, requiresBody);
            this.registerComponent(descriptor, true);
            if (alias.length() <= 0) continue;
            this.registerComponent(descriptor, Key.of(alias), true);
        }
    }
}

