/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.segments.DatasourceConfig;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.jdbc.DataSource;
import ortus.boxlang.runtime.jdbc.drivers.GenericJDBCDriver;
import ortus.boxlang.runtime.jdbc.drivers.IJDBCDriver;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class DatasourceService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceService.class);
    private Map<Key, DataSource> datasources = new HashMap<Key, DataSource>();
    private Map<Key, IJDBCDriver> jdbcDrivers = new HashMap<Key, IJDBCDriver>();

    public DatasourceService(BoxRuntime runtime) {
        super(runtime, Key.datasourceService);
    }

    @Override
    public void onStartup() {
        BoxRuntime.timerUtil.start("datasourceservice-startup");
        logger.debug("+ Starting up DataSourceService...");
        this.registerDriver(new GenericJDBCDriver());
        this.announce(BoxEvent.ON_DATASOURCE_SERVCE_STARTUP, Struct.of(new Object[]{"DatasourceService", this}));
        logger.info("+ Datasource Service started in [{}] ms", (Object)BoxRuntime.timerUtil.stopAndGetMillis("datasourceservice-startup"));
    }

    @Override
    public void onShutdown(Boolean force) {
        this.announce(BoxEvent.ON_DATASOURCE_SERVICE_SHUTDOWN, Struct.of(new Object[]{"DatasourceService", this}));
        this.clear();
        logger.debug("+ Datasource Service shutdown");
    }

    public DatasourceService registerDriver(IJDBCDriver driver) {
        this.jdbcDrivers.put(driver.getName(), driver);
        return this;
    }

    public IJDBCDriver getDriver(Key name) {
        return this.jdbcDrivers.get(name);
    }

    public IJDBCDriver getGenericDriver() {
        return this.jdbcDrivers.get(Key.generic);
    }

    public Boolean hasDriver(Key name) {
        return this.jdbcDrivers.containsKey(name);
    }

    public Boolean removeDriver(Key name) {
        return this.jdbcDrivers.remove(name) != null;
    }

    public DatasourceService clearDrivers() {
        this.jdbcDrivers.clear();
        return this;
    }

    public Integer driverSize() {
        return this.jdbcDrivers.size();
    }

    public String[] getDriverNames() {
        return (String[])this.jdbcDrivers.keySet().stream().map(Key::getName).sorted().toArray(String[]::new);
    }

    public DataSource register(DatasourceConfig config) {
        return this.datasources.computeIfAbsent(config.getUniqueName(), key -> new DataSource(config));
    }

    public DataSource register(Key name, IStruct properties) {
        return this.register(new DatasourceConfig(name, properties));
    }

    public DataSource register(Key name, DataSource datasource) {
        this.datasources.put(name, datasource);
        return datasource;
    }

    public Boolean has(Key name) {
        return this.datasources.containsKey(name);
    }

    public Boolean has(DatasourceConfig config) {
        return this.has(config.getUniqueName());
    }

    public DataSource get(Key name) {
        return this.datasources.get(name);
    }

    public DataSource get(DatasourceConfig config) {
        return this.get(config.getUniqueName());
    }

    public Boolean remove(Key name) {
        DataSource datasource = this.datasources.get(name);
        if (datasource != null) {
            datasource.shutdown();
            this.datasources.remove(name);
            return true;
        }
        return false;
    }

    public Boolean remove(DatasourceConfig config) {
        return this.remove(config.getUniqueName());
    }

    public DatasourceService clear() {
        this.datasources.values().parallelStream().forEach(DataSource::shutdown);
        this.datasources.clear();
        return this;
    }

    public Integer size() {
        return this.datasources.size();
    }

    public String[] getNames() {
        return (String[])this.datasources.keySet().stream().map(Key::getName).sorted().toArray(String[]::new);
    }
}

