/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.bifs.BIFNamespace;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.ObjectRef;

public class FunctionService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(FunctionService.class);
    private Map<Key, BIFDescriptor> globalFunctions = new ConcurrentHashMap<Key, BIFDescriptor>();
    private Map<Key, BIFNamespace> namespaces = new ConcurrentHashMap<Key, BIFNamespace>();
    private Map<Key, Map<BoxLangType, MemberDescriptor>> memberMethods = new ConcurrentHashMap<Key, Map<BoxLangType, MemberDescriptor>>();

    public FunctionService(BoxRuntime runtime) {
        super(runtime, Key.functionService);
    }

    @Override
    public void onStartup() {
        String timerLabel = "functionservice-loadglobalfunctions" + System.currentTimeMillis();
        BoxRuntime.timerUtil.start(timerLabel);
        try {
            this.loadGlobalFunctions();
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Cannot load global functions", e);
        }
        logger.info("+ Function Service: Registered [{}] global functions in [{}] ms", (Object)this.getGlobalFunctionCount(), (Object)BoxRuntime.timerUtil.stopAndGetMillis(timerLabel));
    }

    @Override
    public void onShutdown(Boolean force) {
        logger.info("FunctionService.onShutdown()");
    }

    public long getGlobalFunctionCount() {
        return this.globalFunctions.size();
    }

    public String[] getGlobalFunctionNames() {
        return (String[])this.globalFunctions.keySet().stream().sorted().map(Key::getName).toArray(String[]::new);
    }

    public Boolean hasGlobalFunction(String name) {
        return this.hasGlobalFunction(Key.of(name));
    }

    public Boolean hasGlobalFunction(Key name) {
        return this.globalFunctions.containsKey(name);
    }

    public BIFDescriptor getGlobalFunction(String name) {
        return this.getGlobalFunction(Key.of(name));
    }

    public BIFDescriptor getGlobalFunction(Key name) {
        return this.globalFunctions.get(name);
    }

    public MemberDescriptor getMemberMethod(IBoxContext context, Key name, Object object) {
        return this.getMemberMethod(context, name, ObjectRef.of(object));
    }

    public MemberDescriptor getMemberMethod(IBoxContext context, Key name, ObjectRef object) {
        Map<BoxLangType, MemberDescriptor> targetMethodMap = this.memberMethods.get(name);
        if (targetMethodMap != null) {
            for (Map.Entry<BoxLangType, MemberDescriptor> entry : targetMethodMap.entrySet()) {
                MemberDescriptor descriptor = entry.getValue();
                if ((descriptor.type == BoxLangType.CUSTOM || descriptor.type == BoxLangType.CUSTOM2 || descriptor.type == BoxLangType.CUSTOM3) && descriptor.customClass.isInstance(object.get())) {
                    return descriptor;
                }
                CastAttempt<Object> castAttempt = GenericCaster.attempt(context, object.get(), (Object)entry.getKey());
                if (!castAttempt.wasSuccessful()) continue;
                object.set(castAttempt.get());
                return descriptor;
            }
        }
        return null;
    }

    public MemberDescriptor getMemberMethod(Key name, BoxLangType type) {
        Map<BoxLangType, MemberDescriptor> targetMethodMap = this.memberMethods.get(name);
        if (targetMethodMap != null) {
            return targetMethodMap.get((Object)type);
        }
        return null;
    }

    public void registerGlobalFunction(BIFDescriptor descriptor, Key name, Boolean force) {
        if (this.hasGlobalFunction(descriptor.name).booleanValue() && !force.booleanValue()) {
            throw new BoxRuntimeException("Global function " + name.getName() + " already exists");
        }
        this.globalFunctions.put(name, descriptor);
    }

    public void registerGlobalFunction(BIFDescriptor descriptor) {
        this.registerGlobalFunction(descriptor, descriptor.name, false);
    }

    public void unregisterGlobalFunction(Key name) {
        this.globalFunctions.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemberMethod(Key memberKey, MemberDescriptor descriptor) {
        Map<Key, Map<BoxLangType, MemberDescriptor>> map = this.memberMethods;
        synchronized (map) {
            this.memberMethods.putIfAbsent(memberKey, Collections.synchronizedMap(new LinkedHashMap()));
        }
        this.memberMethods.get(memberKey).put(descriptor.type, descriptor);
    }

    public void loadGlobalFunctions() throws IOException {
        ((Stream)ServiceLoader.load(BIF.class, BoxRuntime.class.getClassLoader()).stream().parallel()).map(ServiceLoader.Provider::type).forEach(targetClass -> this.processBIFRegistration((Class<?>)targetClass, null, null));
    }

    public void processBIFRegistration(Class<?> BIFClass, BIF function, String module) {
        BoxMember[] boxMemberAnnotations;
        BoxBIF[] bifAnnotations;
        if (BIFClass == null && function != null) {
            BIFClass = function.getClass();
        } else if (BIFClass == null) {
            throw new BoxRuntimeException("Cannot register global function because no BIF class or function was provided");
        }
        String className = BIFClass.getSimpleName();
        Key classNameKey = Key.of(className);
        BIFDescriptor descriptor = new BIFDescriptor(classNameKey, BIFClass, module, null, true, function);
        for (BoxBIF bif : bifAnnotations = (BoxBIF[])BIFClass.getAnnotationsByType(BoxBIF.class)) {
            this.registerGlobalFunction(descriptor, bif.alias().equals("") ? classNameKey : Key.of(bif.alias()), true);
        }
        for (BoxMember member : boxMemberAnnotations = (BoxMember[])BIFClass.getAnnotationsByType(BoxMember.class)) {
            Key memberKey = member.name().equals("") ? Key.of(className.toLowerCase().replaceAll(member.type().name().toLowerCase(), "")) : Key.of(member.name());
            this.registerMemberMethod(memberKey, new MemberDescriptor(memberKey, member.type(), member.customType(), member.objectArgument().equals("") ? null : Key.of(member.objectArgument()), descriptor));
        }
    }

    public long getNamespaceCount() {
        return this.namespaces.size();
    }
}

