/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.modules.ModuleRecord;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class ModuleService
extends BaseService {
    public static final String MODULE_MAPPING_PREFIX = "/bxModules/";
    public static final String MODULE_MAPPING_INVOCATION_PREFIX = "bxModules.";
    public static final String MODULE_DESCRIPTOR = "ModuleConfig.bx";
    public static final String MODULE_BIFS = "bifs";
    public static final String MODULE_COMPONENTS = "components";
    public static final String MODULE_LIBS = "libs";
    public static final String MODULE_PACKAGE_PREFIX = "modules";
    private List<Path> modulePaths = new ArrayList<Path>();
    private static final Logger logger = LoggerFactory.getLogger(ModuleService.class);
    private Map<Key, ModuleRecord> registry = new ConcurrentHashMap<Key, ModuleRecord>();

    public ModuleService(BoxRuntime runtime) {
        super(runtime, Key.moduleService);
    }

    public List<Path> getModulePaths() {
        return this.modulePaths;
    }

    @Override
    public void onStartup() {
        BoxRuntime.timerUtil.start("moduleservice-startup");
        logger.debug("+ Starting up Module Service...");
        this.runtime.getConfiguration().modulesDirectory.forEach(this::addModulePath);
        this.registerAll();
        this.activateAll();
        this.announce(BoxEvent.ON_MODULE_SERVICE_STARTUP, Struct.of(new Object[]{"moduleService", this}));
        logger.info("+ Module Service started in [{}] ms", (Object)BoxRuntime.timerUtil.stopAndGetMillis("moduleservice-startup"));
    }

    @Override
    public void onShutdown(Boolean force) {
        this.announce(BoxEvent.ON_MODULE_SERVICE_SHUTDOWN, Struct.of(new Object[]{"moduleService", this}));
        this.unloadAll();
        logger.debug("+ Module Service shutdown");
    }

    void registerAll() {
        String timerLabel = "moduleservice-registerallmodules";
        BoxRuntime.timerUtil.start(timerLabel);
        this.buildRegistry();
        this.registry.keySet().stream().forEach(this::register);
        logger.debug("+ Module Service: Registered [{}] modules in [{}] ms", (Object)this.registry.size(), (Object)BoxRuntime.timerUtil.stopAndGetMillis(timerLabel));
        this.announce(BoxEvent.AFTER_MODULE_REGISTRATIONS, Struct.of(new Object[]{"moduleRegistry", this.registry}));
    }

    void register(Key name) {
        String timerLabel = "moduleservice-register-" + name.getName();
        BoxRuntime.timerUtil.start(timerLabel);
        if (!this.registry.containsKey(name)) {
            throw new BoxRuntimeException("Cannot register the module [" + String.valueOf(name) + "] is not in the module registry.Valid modules are: " + this.registry.keySet().toString());
        }
        ModuleRecord moduleRecord = this.registry.get(name);
        IBoxContext runtimeContext = this.runtime.getRuntimeContext();
        this.announce(BoxEvent.PRE_MODULE_REGISTRATION, Struct.of(new Object[]{"moduleRecord", moduleRecord, "moduleName", name}));
        moduleRecord.loadDescriptor(runtimeContext);
        if (moduleRecord.isDisabled()) {
            logger.warn("+ Module Service: Module [{}] is disabled, skipping registration", (Object)moduleRecord.name);
            return;
        }
        moduleRecord.register(runtimeContext);
        moduleRecord.registrationTime = BoxRuntime.timerUtil.stopAndGetMillis(timerLabel);
        this.announce(BoxEvent.POST_MODULE_REGISTRATION, Struct.of(new Object[]{"moduleRecord", moduleRecord, "moduleName", name}));
        logger.debug("+ Module Service: Registered module [{}@{}] in [{}] ms from [{}]", moduleRecord.name.getName(), moduleRecord.version, moduleRecord.registrationTime, moduleRecord.physicalPath);
    }

    void activateAll() {
        String timerLabel = "moduleservice-activateallmodules";
        BoxRuntime.timerUtil.start(timerLabel);
        this.registry.keySet().stream().forEach(this::activate);
        logger.debug("+ Module Service: Activated [{}] modules in [{}] ms", (Object)this.registry.size(), (Object)BoxRuntime.timerUtil.stopAndGetMillis(timerLabel));
        this.announce(BoxEvent.AFTER_MODULE_ACTIVATIONS, Struct.of(new Object[]{"moduleRegistry", this.registry}));
    }

    void activate(Key name) {
        String timerLabel = "moduleservice-activate-" + name.getName();
        BoxRuntime.timerUtil.start(timerLabel);
        if (!this.registry.containsKey(name)) {
            throw new BoxRuntimeException("Cannot activate the module [" + String.valueOf(name) + "] is not in the module registry.Valid modules are: " + this.registry.keySet().toString());
        }
        if (this.registry.get(name).isActivated()) {
            logger.warn("+ Module Service: Module [{}] is already activated, skipping re-activation", (Object)name);
            return;
        }
        if (this.registry.get(name).isDisabled()) {
            logger.debug("+ Module Service: Module [{}] is disabled, skipping activation", (Object)name);
            return;
        }
        ModuleRecord moduleRecord = this.registry.get(name);
        IBoxContext runtimeContext = this.runtime.getRuntimeContext();
        this.announce(BoxEvent.PRE_MODULE_LOAD, Struct.of(new Object[]{"moduleRecord", moduleRecord, "moduleName", name}));
        moduleRecord.activate(runtimeContext);
        moduleRecord.activationTime = BoxRuntime.timerUtil.stopAndGetMillis(timerLabel);
        this.announce(BoxEvent.POST_MODULE_LOAD, Struct.of(new Object[]{"moduleRecord", moduleRecord, "moduleName", name}));
        logger.debug("+ Module Service: Activated module [{}@{}] in [{}] ms", moduleRecord.name.getName(), moduleRecord.version, moduleRecord.activationTime);
    }

    void unloadAll() {
        this.registry.keySet().stream().forEach(this::unload);
    }

    void unload(Key name) {
        if (!this.registry.containsKey(name) || !this.registry.get(name).isActivated()) {
            return;
        }
        ModuleRecord moduleRecord = this.registry.get(name);
        IBoxContext runtimeContext = this.runtime.getRuntimeContext();
        this.announce(BoxEvent.PRE_MODULE_UNLOAD, Struct.of(new Object[]{"moduleRecord", moduleRecord, "moduleName", name}));
        moduleRecord.unload(runtimeContext);
        this.announce(BoxEvent.POST_MODULE_UNLOAD, Struct.of(new Object[]{"moduleRecord", moduleRecord, "moduleName", name}));
        logger.debug("+ Module Service: Unload module [{}@{}]", (Object)moduleRecord.name, (Object)moduleRecord.version);
        this.registry.remove(name);
    }

    public Map<Key, ModuleRecord> getRegistry() {
        return this.registry;
    }

    public List<Key> getModuleNames() {
        return new ArrayList<Key>(this.registry.keySet());
    }

    public ModuleRecord getModuleRecord(Key name) {
        return this.registry.get(name);
    }

    public IStruct getModuleSettings(Key name) {
        ModuleRecord moduleRecord = this.getModuleRecord(name);
        if (moduleRecord == null) {
            throw new BoxRuntimeException(String.format("The module [%s] is not registered in the current runtime", name.getName()));
        }
        return moduleRecord.settings;
    }

    public boolean hasModule(Key name) {
        return this.registry.containsKey(name);
    }

    public ModuleService addModulePath(String path) {
        if (path == null || path.isBlank()) {
            return this;
        }
        return this.addModulePath(Paths.get(path, new String[0]));
    }

    public ModuleService addModulePath(Path path) {
        if (path == null || path.toString().isBlank()) {
            return this;
        }
        if (!Files.exists(path = path.toAbsolutePath(), new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileSystemException && e.getMessage().contains("Read-only file system")) {
                    logger.warn("ModuleService: Cannot create module path [{}] as it is on a read-only file system", (Object)path.toString());
                    return this;
                }
                throw new BoxRuntimeException("Error creating module path: " + path.toString(), e);
            }
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.modulePaths.add(path);
            logger.debug("+ ModuleService: Added an external module path: [{}]", (Object)path.toString());
        } else {
            logger.warn("ModuleService: Requested addModulePath [{}] does not exist or is not a directory", (Object)path.toString());
        }
        return this;
    }

    private void buildRegistry() {
        this.modulePaths.stream().flatMap(path -> {
            try {
                return Files.walk(path, 1, new FileVisitOption[0]);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error walking module path: " + path.toString(), e);
            }
        }).filter(filePath -> !this.modulePaths.contains(filePath)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(filePath -> Files.exists(filePath.resolve(MODULE_DESCRIPTOR), new LinkOption[0])).filter(filePath -> !this.registry.containsKey(Key.of(filePath.getFileName().toString()))).map(filePath -> new ModuleRecord(filePath.toString())).forEach(moduleRecord -> this.registry.put(moduleRecord.name, (ModuleRecord)moduleRecord));
    }
}

