/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.services;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.async.tasks.IScheduler;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.BaseService;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class SchedulerService
extends BaseService {
    private Map<Key, IScheduler> schedulers = new ConcurrentHashMap<Key, IScheduler>();
    private static final Logger logger = LoggerFactory.getLogger(SchedulerService.class);

    public SchedulerService(BoxRuntime runtime) {
        super(runtime, Key.schedulerService);
    }

    @Override
    public void onStartup() {
        BoxRuntime.timerUtil.start("schedulerservice-startup");
        logger.debug("+ Starting up Scheduler Service...");
        this.startupSchedulers();
        this.announce(BoxEvent.ON_SCHEDULER_SERVICE_STARTUP, Struct.of(new Object[]{"schedulerService", this}));
        logger.info("+ Scheduler Service started in [{}] ms", (Object)BoxRuntime.timerUtil.stopAndGetMillis("schedulerservice-startup"));
    }

    @Override
    public void onShutdown(Boolean force) {
        this.announce(BoxEvent.ON_SCHEDULER_SERVICE_SHUTDOWN, Struct.of(new Object[]{"schedulerService", this}));
        this.schedulers.values().parallelStream().forEach(scheduler -> this.shutdownScheduler((IScheduler)scheduler, false, 0L));
        logger.debug("+ Scheduler Service shutdown");
    }

    public SchedulerService startupSchedulers() {
        this.schedulers.values().parallelStream().filter(scheduler -> scheduler.hasStarted() == false).forEach(scheduler -> {
            logger.debug("+ Starting up scheduler [{}] ...", (Object)scheduler.getName());
            scheduler.startup();
            this.announce(BoxEvent.ON_SCHEDULER_STARTUP, Struct.of(new Object[]{"scheduler", scheduler}));
        });
        this.announce(BoxEvent.ON_ALL_SCHEDULERS_STARTED, Struct.of(new Object[]{"schedulers", this.schedulers}));
        return this;
    }

    public Map<Key, IScheduler> getSchedulers() {
        return this.schedulers;
    }

    public IScheduler getScheduler(Key name) {
        return this.schedulers.get(name);
    }

    public int size() {
        return this.schedulers.size();
    }

    public boolean hasScheduler(Key name) {
        return this.schedulers.containsKey(name);
    }

    public IScheduler registerScheduler(IScheduler scheduler) {
        return this.registerScheduler(scheduler, false);
    }

    public IScheduler registerScheduler(IScheduler scheduler, Boolean force) {
        if (this.schedulers.containsKey(Key.of(scheduler.getName())) && !force.booleanValue()) {
            throw new BoxRuntimeException("A scheduler with the name [" + scheduler.getName() + "] already exists");
        }
        this.schedulers.put(Key.of(scheduler.getName()), scheduler);
        this.announce(BoxEvent.ON_SCHEDULER_REGISTRATION, Struct.of(new Object[]{"scheduler", scheduler, "force", force}));
        return scheduler;
    }

    public IScheduler loadScheduler(Key name, IScheduler scheduler) {
        this.registerScheduler(scheduler.setName(name.getName()), true);
        scheduler.configure();
        return scheduler;
    }

    public boolean removeScheduler(Key name, boolean force, long timeout) {
        IScheduler scheduler = this.schedulers.remove(name);
        if (scheduler != null) {
            this.announce(BoxEvent.ON_SCHEDULER_REMOVAL, Struct.of(new Object[]{"scheduler", scheduler, "force", force, "timeout", timeout}));
            this.shutdownScheduler(scheduler, force, timeout);
            return true;
        }
        return false;
    }

    public boolean removeScheduler(Key name) {
        return this.removeScheduler(name, false, 0L);
    }

    public void clearSchedulers(Boolean force, Long timeout) {
        this.schedulers.values().parallelStream().forEach(scheduler -> this.shutdownScheduler((IScheduler)scheduler, force, timeout));
        this.schedulers.clear();
    }

    public boolean restartScheduler(Key name, boolean force, long timeout) {
        IScheduler scheduler = this.schedulers.get(name);
        if (scheduler != null) {
            this.announce(BoxEvent.ON_SCHEDULER_RESTART, Struct.of(new Object[]{"scheduler", scheduler, "force", force, "timeout", timeout}));
            scheduler.restart(force, timeout);
            return true;
        }
        return false;
    }

    public boolean restartScheduler(Key name) {
        return this.restartScheduler(name, false, 0L);
    }

    private void shutdownScheduler(IScheduler scheduler, Boolean force, Long timeout) {
        logger.debug("+ Shutting down scheduler [{}]", (Object)scheduler.getName());
        this.announce(BoxEvent.ON_SCHEDULER_SHUTDOWN, Struct.of(new Object[]{"scheduler", scheduler, "force", force, "timeout", timeout}));
        scheduler.shutdown(force, timeout);
    }
}

