/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.Serializable;
import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.DefaultExpression;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.util.DuplicationUtil;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public record Argument(boolean required, String type, Key name, Object defaultValue, DefaultExpression defaultExpression, IStruct annotations, IStruct documentation, Set<Validator> validators) implements Validatable,
Serializable
{
    private static final long serialVersionUID = 1L;
    public static final String ANY = "any";
    public static final String ARRAY = "array";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String DOUBLE = "double";
    public static final String FILE = "file";
    public static final String FUNCTION = "function";
    public static final String INTEGER = "integer";
    public static final String LIST = "list";
    public static final String LONG = "long";
    public static final String MODIFIABLE_ARRAY = "modifiableArray";
    public static final String MODIFIABLE_STRUCT = "modifiableStruct";
    public static final String MODIFIABLE_QUERY = "modifiableQuery";
    public static final String NUMERIC = "numeric";
    public static final String QUERY = "query";
    public static final String STRING = "string";
    public static final String STRUCT = "struct";
    public static final String STRUCT_LOOSE = "structloose";
    public static final String UDF = "udf";
    public static final String CLOSURE = "closure";
    public static final String LAMBDA = "lambda";
    public static final String XML = "xml";

    public Argument(Key name) {
        this(false, ANY, name);
    }

    public Argument(Key name, Set<Validator> validators) {
        this(false, ANY, name, validators);
    }

    public Argument(boolean required, String type, Key name) {
        this(required, type, name, null, null, Struct.EMPTY, Struct.EMPTY, Set.of());
    }

    public Argument(boolean required, String type, Key name, Set<Validator> validators) {
        this(required, type, name, null, null, Struct.EMPTY, Struct.EMPTY, validators);
    }

    public Argument(boolean required, String type, Key name, Object defaultValue) {
        this(required, type, name, defaultValue, null, Struct.EMPTY, Struct.EMPTY, Set.of());
    }

    public Argument(boolean required, String type, Key name, Object defaultValue, Set<Validator> validators) {
        this(required, type, name, defaultValue, null, Struct.EMPTY, Struct.EMPTY, validators);
    }

    public Argument(boolean required, String type, Key name, Object defaultValue, IStruct annotations) {
        this(required, type, name, defaultValue, null, annotations, Struct.EMPTY, Set.of());
    }

    public Argument(boolean required, String type, Key name, Object defaultValue, IStruct annotations, Set<Validator> validators) {
        this(required, type, name, defaultValue, null, annotations, Struct.EMPTY, validators);
    }

    public Argument(boolean required, String type, Key name, Object defaultValue, DefaultExpression defaultExpression, IStruct annotations, IStruct documentation) {
        this(required, type, name, defaultValue, defaultExpression, annotations, documentation, Set.of());
    }

    public Object getDefaultValue(IBoxContext context) {
        if (this.defaultExpression != null) {
            return this.defaultExpression.evaluate(context);
        }
        return DuplicationUtil.duplicate(this.defaultValue, false);
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null || this.defaultExpression != null;
    }

    public Boolean implementsSignature(Argument arg) {
        if (arg.required() && arg.required() != this.required()) {
            return false;
        }
        if (!arg.name().equals(this.name())) {
            return false;
        }
        if (!arg.type().equalsIgnoreCase(ANY) && !arg.type().equalsIgnoreCase(this.type())) {
            return false;
        }
        if (arg.defaultValue() != null && !arg.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        return true;
    }

    public String signatureAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.required()) {
            sb.append("required ");
        }
        sb.append(this.type());
        sb.append(" ");
        sb.append(this.name().getName());
        if (this.defaultValue() != null) {
            sb.append(" = ");
            sb.append(this.defaultValue());
        }
        if (this.defaultExpression() != null) {
            sb.append(" = ");
            sb.append("<Runtime Expression>");
        }
        return sb.toString();
    }
}

