/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BoxMemberExpose;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.operators.Compare;
import ortus.boxlang.runtime.operators.EqualsEquals;
import ortus.boxlang.runtime.scopes.IntKey;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.GenericMeta;
import ortus.boxlang.runtime.types.meta.IChangeListener;
import ortus.boxlang.runtime.types.meta.IListenable;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableArray;
import ortus.boxlang.runtime.types.util.BLCollector;

public class Array
implements List<Object>,
IType,
IReferenceable,
IListenable,
Serializable {
    public static final Array EMPTY = new UnmodifiableArray();
    protected final List<Object> wrapped;
    public transient BoxMeta $bx;
    private transient Map<Key, IChangeListener> listeners;
    private static FunctionService functionService = BoxRuntime.getInstance().getFunctionService();
    private static final long serialVersionUID = 1L;
    public boolean containsDelimiters = false;

    public Array() {
        this(10);
    }

    public Array(int initialCapactity) {
        this.wrapped = Collections.synchronizedList(new ArrayList(initialCapactity));
    }

    public Array(Object[] arr) {
        this.wrapped = Collections.synchronizedList(new ArrayList<Object>(Arrays.asList(arr)));
    }

    public Array(List<? extends Object> list) {
        this.wrapped = list;
    }

    public static Array fromString(String list) {
        return Array.fromString(list, ",");
    }

    public static Array fromString(String list, String delimiter) {
        if (delimiter == null) {
            delimiter = ",";
        }
        return Arrays.stream(list.split(delimiter)).map(String::trim).collect(BLCollector.toArray());
    }

    public static Array fromList(List<? extends Object> list) {
        return new Array(list);
    }

    public static Array fromSet(Set<? extends Object> set) {
        return new Array(new ArrayList<Object>(set));
    }

    public static Array fromArray(Object[] arr) {
        return new Array(arr);
    }

    @BoxMemberExpose
    public static Array of(Object ... values) {
        return Array.fromArray(values);
    }

    @BoxMemberExpose
    public static Array copyOf(List<?> arr) {
        Array newArr = new Array();
        for (Object o : arr) {
            newArr.add(o);
        }
        return newArr;
    }

    public Object toVarArgsArray(Class<?> varArgType) {
        Object array = java.lang.reflect.Array.newInstance(varArgType, this.wrapped.size());
        System.arraycopy(this.wrapped.toArray(), 0, array, 0, this.wrapped.size());
        return array;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrapped.toArray(a);
    }

    public List<Object> toList() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object e) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            return this.wrapped.add(this.notifyListeners(this.wrapped.size(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Object element) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            this.wrapped.add(index, this.notifyListeners(index, element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            ListIterator<Object> iterator = this.wrapped.listIterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!element.equals(o)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Object> c) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            return this.wrapped.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            return this.wrapped.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            return this.wrapped.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            return this.wrapped.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<Object> list = this.wrapped;
        synchronized (list) {
            this.wrapped.clear();
        }
    }

    @Override
    public Object get(int index) {
        return this.wrapped.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        return this.wrapped.set(index, this.notifyListeners(index, element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(int index) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            ListIterator<Object> iterator = this.wrapped.listIterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (i == index) {
                    iterator.remove();
                    return element;
                }
                ++i;
            }
            return null;
        }
    }

    public Object removeAt(Number index) {
        return this.remove(index.intValue());
    }

    @Override
    public int indexOf(Object o) {
        return this.wrapped.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrapped.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.wrapped.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.wrapped.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.wrapped.subList(fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(Object e) {
        List<Object> list = this.wrapped;
        synchronized (list) {
            this.add(e);
            return this.wrapped.size();
        }
    }

    @Override
    public void sort(Comparator compareFunc) {
        this.wrapped.sort(compareFunc);
    }

    @Override
    @BoxMemberExpose
    public Stream<Object> stream() {
        return this.wrapped.stream();
    }

    @Override
    @BoxMemberExpose
    public Stream<Object> parallelStream() {
        return this.wrapped.parallelStream();
    }

    public IntStream intStream() {
        return IntStream.range(0, this.size());
    }

    public Array reverse() {
        Collections.reverse(this.wrapped);
        return this;
    }

    @Override
    @BoxMemberExpose
    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.computeHashCode(IType.createIdentitySetForType());
    }

    @Override
    public int computeHashCode(Set<IType> visited) {
        if (visited.contains(this)) {
            return 0;
        }
        visited.add(this);
        int result = 1;
        for (Object value : this.wrapped.toArray()) {
            result = value instanceof IType ? 31 * result + ((IType)value).computeHashCode(visited) : 31 * result + (value == null ? 0 : value.hashCode());
        }
        return result;
    }

    public String toString() {
        return this.wrapped.toString();
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n  ");
        sb.append(this.wrapped.stream().map(value -> {
            String string;
            if (value instanceof IType) {
                IType t = (IType)value;
                string = t.asString();
            } else {
                string = value == null ? "[null]" : value.toString();
            }
            return string;
        }).map(line -> line.replaceAll("(?m)^", "  ")).collect(Collectors.joining(",\n")));
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new GenericMeta(this);
        }
        return this.$bx;
    }

    public Array insertAt(int index, Object element) {
        if (index < 1 || index > this.wrapped.size()) {
            throw new BoxRuntimeException("Index [" + index + "] out of bounds for list with " + this.wrapped.size() + " elements.");
        }
        this.add(index - 1, element);
        return this;
    }

    public Array push(Object element) {
        this.add(element);
        return this;
    }

    public Object getAt(int index) {
        if (index < 1 || index > this.wrapped.size()) {
            throw new BoxRuntimeException("Index [" + index + "] out of bounds for list with " + this.wrapped.size() + " elements.");
        }
        return this.get(index - 1);
    }

    public Array setAt(int index, Object element) {
        if (index < 1 || index > this.wrapped.size()) {
            throw new BoxRuntimeException("Index [" + index + "] out of bounds for list with " + this.wrapped.size() + " elements.");
        }
        this.set(index - 1, element);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array deleteAt(int index) {
        if (index < 1 || index > this.wrapped.size()) {
            throw new BoxRuntimeException("Index [" + index + "] out of bounds for list with " + this.wrapped.size() + " elements.");
        }
        if (this.containsDelimiters) {
            index *= 2;
        }
        List<Object> list = this.wrapped;
        synchronized (list) {
            this.remove(index - 1);
            if (this.containsDelimiters && this.size() >= index - 1) {
                this.remove(index - 1);
            }
            this.notifyListeners(index - 1, null);
        }
        return this;
    }

    public int findIndexWithSubstring(Object value, Boolean caseSensitive) {
        return this.intStream().filter(i -> caseSensitive == false && StringUtils.containsAnyIgnoreCase(this.get(i).toString(), value.toString()) || caseSensitive != false && this.get(i).toString().contains(value.toString())).findFirst().orElse(-1) + 1;
    }

    public int findIndex(Object value, Boolean caseSensitive) {
        return this.intStream().filter(i -> EqualsEquals.invoke(this.get(i), value, caseSensitive) != false || this.get(i).equals(value)).findFirst().orElse(-1) + 1;
    }

    public int findIndex(Object value) {
        return this.findIndex(value, true);
    }

    public int findIndex(Function test, IBoxContext context) {
        return this.intStream().filter(i -> BooleanCaster.cast(test.requiresStrictArguments() ? context.invokeFunction((Object)test, new Object[]{this.get(i)}) : context.invokeFunction((Object)test, new Object[]{this.get(i), i, this}))).findFirst().orElse(-1) + 1;
    }

    public Array removeDuplicates() {
        return this.removeDuplicates(true);
    }

    public Array removeDuplicates(Boolean caseSensitive) {
        Array ref = this;
        Array distinct = new Array(ref.stream().collect(Collectors.groupingBy(item -> caseSensitive != false ? item : Key.of(item), Collectors.counting())).keySet().stream().map(item -> StringCaster.cast(item)).toArray());
        distinct.sort((a, b) -> Compare.invoke(ref.findIndex(a), ref.findIndex(b)));
        return distinct;
    }

    public Array withDelimiters() {
        this.containsDelimiters = true;
        return this;
    }

    public UnmodifiableArray toUnmodifiable() {
        return new UnmodifiableArray(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        Integer index = Array.validateAndGetIntForAssign(key, this.wrapped.size(), false);
        if (index > this.wrapped.size()) {
            List<Object> list = this.wrapped;
            synchronized (list) {
                for (int i = this.wrapped.size(); i < index; ++i) {
                    this.wrapped.add(null);
                }
            }
        }
        this.wrapped.set(index - 1, value);
        return value;
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        if (key.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        Integer index = Array.validateAndGetIntForDereference(key, this.wrapped.size(), safe);
        if (safe.booleanValue() && (index < 1 || index > this.wrapped.size())) {
            return null;
        }
        return this.wrapped.get(index - 1);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.ARRAY);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.ARRAY);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
    }

    @Override
    public void registerChangeListener(IChangeListener listener) {
        this.initListeners();
        this.listeners.put(IListenable.ALL_KEYS, listener);
    }

    @Override
    public void registerChangeListener(Key key, IChangeListener listener) {
        this.initListeners();
        this.listeners.put(key, listener);
    }

    @Override
    public void removeChangeListener(Key key) {
        this.initListeners();
        this.listeners.remove(key);
    }

    private Object notifyListeners(int i, Object value) {
        if (this.listeners == null) {
            return value;
        }
        IntKey key = Key.of(i + 1);
        IChangeListener listener = this.listeners.get(key);
        if (listener == null) {
            listener = this.listeners.get(IListenable.ALL_KEYS);
        }
        if (listener == null) {
            return value;
        }
        return listener.notify(key, value, i < this.wrapped.size() ? this.wrapped.get(i) : null);
    }

    private void initListeners() {
        if (this.listeners == null) {
            this.listeners = new ConcurrentHashMap<Key, IChangeListener>();
        }
    }

    public static int validateAndGetIntForDereference(Key key, int size, boolean safe) {
        Integer index = Array.getIntFromKey(key, safe);
        if (safe) {
            return index;
        }
        if (index < 1) {
            throw new BoxRuntimeException("Array cannot be indexed by a number smaller than 1");
        }
        if (index > size) {
            throw new BoxRuntimeException(String.format("Array index [%s] is out of bounds for an array of length [%s]", index, size));
        }
        return index;
    }

    public static int validateAndGetIntForAssign(Key key, int size, boolean isNative) {
        Integer index = Array.getIntFromKey(key, false);
        if (index < 1) {
            throw new BoxRuntimeException("Array cannot be assigned by a number smaller than 1");
        }
        if (isNative && index > size) {
            throw new BoxRuntimeException(String.format("Invalid index [%s] for Native Array, can't expand Native Arrays.  Current array length is [%s]", index, size));
        }
        return index;
    }

    public static int getIntFromKey(Key key, boolean safe) {
        Integer index;
        if (key instanceof IntKey) {
            IntKey intKey = (IntKey)key;
            index = intKey.getIntValue();
        } else {
            CastAttempt<Number> indexAtt = NumberCaster.attempt(key.getName());
            if (!indexAtt.wasSuccessful()) {
                if (safe) {
                    return -1;
                }
                throw new BoxRuntimeException(String.format("Array cannot be assigned with key %s", key.getName()));
            }
            Number dIndex = indexAtt.get();
            index = dIndex.intValue();
            if (index.doubleValue() != dIndex.doubleValue()) {
                if (safe) {
                    return -1;
                }
                throw new BoxRuntimeException(String.format("Array index [%s] is invalid.  Index must be an integer.", dIndex));
            }
        }
        return index;
    }
}

