/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import ortus.boxlang.runtime.scopes.Key;

public enum BoxLangType {
    ANY(Key._ANY),
    ARRAY(Key._ARRAY),
    BOOLEAN(Key._BOOLEAN),
    CLASS(Key._CLASS),
    CLOSURE(Key.closure),
    CUSTOM(Key.custom),
    CUSTOM2(Key.custom2),
    CUSTOM3(Key.custom3),
    DATE(Key._DATE),
    DATETIME(Key._DATETIME),
    DOUBLE(Key._DOUBLE),
    FILE(Key._FILE),
    FUNCTION(Key.function),
    INTEGER(Key._INTEGER),
    LAMBDA(Key.lambda),
    LIST(Key._LIST),
    LONG(Key._LONG),
    MODIFIABLE_ARRAY(Key.modifiableArray),
    MODIFIABLE_STRUCT(Key.modifiableStruct),
    MODIFIABLE_QUERY(Key.modifiableQuery),
    NUMERIC(Key._NUMERIC),
    QUERY(Key._QUERY),
    STRING(Key._STRING),
    STRUCT(Key._STRUCT),
    STRUCT_LOOSE(Key.structLoose),
    UDF(Key._UDF),
    XML(Key.XML),
    STREAM(Key.stream);

    private final Key key;

    private BoxLangType(Key value) {
        this.key = value;
    }

    public Key getKey() {
        return this.key;
    }

    public static boolean isValid(Key value) {
        for (BoxLangType type : BoxLangType.values()) {
            if (!type.getKey().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(String value) {
        return BoxLangType.isValid(Key.of(value));
    }

    public String toString() {
        return this.key.getName();
    }
}

