/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BoxMemberExpose;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.GenericMeta;
import ortus.boxlang.runtime.util.LocalizationUtil;

public class DateTime
implements IType,
IReferenceable,
Serializable,
ValueWriter,
ChronoZonedDateTime<LocalDate> {
    private static final long serialVersionUID = 1L;
    protected ZonedDateTime wrapped;
    public static final String TS_FORMAT_MASK = "'{ts '''yyyy-MM-dd HH:mm:ss'''}'";
    public static final String DEFAULT_DATE_FORMAT_MASK = "dd-MMM-yy";
    public static final String DEFAULT_TIME_FORMAT_MASK = "hh:mm a";
    public static final String DEFAULT_DATETIME_FORMAT_MASK = "dd-MMM-yyyy HH:mm:ss";
    public static final String ISO_DATE_TIME_VARIATION_FORMAT_MASK = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_DATE_TIME_MILIS_FORMAT_MASK = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO_OFFSET_DATE_TIME_NOMILLIS_FORMAT_MASK = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String ISO_DATE_TIME_MILIS_NO_T_FORMAT_MASK = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ODBC_DATE_TIME_FORMAT_MASK = "'{ts '''yyyy-MM-dd HH:mm:ss'''}'";
    public static final String ODBC_DATE_FORMAT_MASK = "'{d '''yyyy-MM-dd'''}'";
    public static final String ODBC_TIME_FORMAT_MASK = "'{t '''HH:mm:ss'''}'";
    public static final String JS_COMMON_TO_STRING_MASK = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)";
    public static final String MODE_DATE = "Date";
    public static final String MODE_TIME = "Time";
    public static final String MODE_DATETIME = "DateTime";
    public static final IStruct COMMON_FORMATTERS = Struct.of("fullDateTime", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.FULL), "longDateTime", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG), "mediumDateTime", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM), "shortDateTime", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT), "ISODateTime", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX"), "ISO8601DateTime", DateTimeFormatter.ISO_OFFSET_DATE_TIME, "ODBCDateTime", DateTimeFormatter.ofPattern("'{ts '''yyyy-MM-dd HH:mm:ss'''}'"), "javascriptDateTime", DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)"), "fullDate", DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL), "longDate", DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG), "mediumDate", DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM), "shortDate", DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT), "ISODate", DateTimeFormatter.ISO_DATE, "ISO8601Date", DateTimeFormatter.ISO_DATE, "ODBCDate", DateTimeFormatter.ofPattern("'{d '''yyyy-MM-dd'''}'"), "fullTime", DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL), "longTime", DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG), "mediumTime", DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM), "shortTime", DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT), "ISOTime", DateTimeFormatter.ISO_TIME, "ISO8601Time", DateTimeFormatter.ISO_TIME, "ODBCTime", DateTimeFormatter.ofPattern("'{t '''HH:mm:ss'''}'"));
    private transient DateTimeFormatter formatter;
    private static final FunctionService functionService = BoxRuntime.getInstance().getFunctionService();
    public transient BoxMeta $bx;

    public DateTime() {
        this(ZoneId.systemDefault());
    }

    public DateTime(ZoneId zoneId) {
        this(ZonedDateTime.now(zoneId));
    }

    public DateTime(ZonedDateTime dateTime) {
        this.formatter = DateTimeFormatter.ofPattern("'{ts '''yyyy-MM-dd HH:mm:ss'''}'");
        this.wrapped = dateTime;
    }

    public DateTime(java.util.Date date) {
        ZonedDateTime zonedDateTime;
        if (date instanceof Date) {
            Date sqlDate = (Date)date;
            zonedDateTime = ZonedDateTime.of(sqlDate.toLocalDate(), LocalTime.of(0, 0), ZoneId.systemDefault());
        } else if (date instanceof Time) {
            Time sqlTime = (Time)date;
            zonedDateTime = ZonedDateTime.of(LocalDate.EPOCH, sqlTime.toLocalTime(), ZoneId.systemDefault());
        } else {
            zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        }
        this(zonedDateTime);
    }

    public DateTime(Date date) {
        this(ZonedDateTime.of(date.toLocalDate(), LocalTime.of(0, 0), ZoneId.systemDefault()));
    }

    public DateTime(Time time) {
        this(ZonedDateTime.of(LocalDate.EPOCH, time.toLocalTime(), ZoneId.systemDefault()));
    }

    public DateTime(LocalTime time) {
        this(ZonedDateTime.of(LocalDate.EPOCH, time, ZoneId.systemDefault()));
    }

    public DateTime(LocalDateTime dateTime) {
        this(ZonedDateTime.of(dateTime, ZoneId.systemDefault()));
    }

    public DateTime(LocalDate date) {
        this(ZonedDateTime.of(date.atStartOfDay(), ZoneId.systemDefault()));
    }

    public DateTime(Instant instant) {
        this.formatter = DateTimeFormatter.ofPattern("'{ts '''yyyy-MM-dd HH:mm:ss'''}'");
        this.wrapped = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public DateTime(String dateTime, String mask) {
        this(dateTime, mask, ZoneId.systemDefault());
    }

    public DateTime(String dateTime, String mask, ZoneId timezone) {
        this.formatter = DateTimeFormatter.ofPattern("'{ts '''yyyy-MM-dd HH:mm:ss'''}'");
        ZonedDateTime parsed = null;
        try {
            parsed = ZonedDateTime.parse(dateTime, DateTime.getFormatter(mask));
        }
        catch (DateTimeParseException e) {
            try {
                parsed = ZonedDateTime.of(LocalDateTime.parse(dateTime, DateTime.getFormatter(mask)), timezone);
            }
            catch (DateTimeParseException x) {
                try {
                    parsed = ZonedDateTime.of(LocalDateTime.of(LocalDate.parse(dateTime, DateTime.getFormatter(mask)), LocalTime.MIN), timezone);
                }
                catch (DateTimeParseException z) {
                    parsed = ZonedDateTime.of(LocalDate.MIN, LocalTime.parse(dateTime, DateTime.getFormatter(mask)), timezone);
                }
            }
            catch (Exception x) {
                throw new BoxRuntimeException(String.format("The the date time value of [%s] could not be parsed as a valid date or datetime", dateTime), x);
            }
        }
        catch (Exception e) {
            throw new BoxRuntimeException(String.format("The the date time value of [%s] could not be parsed using the mask [%s]", dateTime, mask), e);
        }
        this.wrapped = parsed;
    }

    public DateTime(String dateTime) {
        this(dateTime, ZoneId.systemDefault());
    }

    public DateTime(String dateTime, ZoneId timezone) {
        this(dateTime, Locale.getDefault(), timezone);
    }

    public DateTime(String dateTime, Locale locale, ZoneId timezone) {
        this.formatter = DateTimeFormatter.ofPattern("'{ts '''yyyy-MM-dd HH:mm:ss'''}'");
        ZonedDateTime parsed = null;
        this.formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(locale);
        try {
            parsed = ZonedDateTime.parse(dateTime, LocalizationUtil.getLocaleZonedDateTimeParsers(locale));
        }
        catch (DateTimeParseException e) {
            try {
                parsed = ZonedDateTime.of(LocalDateTime.parse(dateTime, LocalizationUtil.getLocaleDateTimeParsers(locale)), timezone);
            }
            catch (DateTimeParseException x) {
                try {
                    parsed = ZonedDateTime.of(LocalDateTime.of(LocalDate.parse(dateTime, LocalizationUtil.getLocaleDateParsers(locale)), LocalTime.MIN), timezone);
                }
                catch (DateTimeParseException z) {
                    parsed = ZonedDateTime.of(LocalDate.MIN, LocalTime.parse(dateTime, LocalizationUtil.getLocaleTimeParsers(locale)), ZoneId.systemDefault());
                }
            }
            catch (Exception x) {
                throw new BoxRuntimeException(String.format("The the date time value of [%s] could not be parsed as a valid date or datetime locale of [%s]", dateTime, locale.getDisplayName()), x);
            }
        }
        catch (Exception e) {
            throw new BoxRuntimeException(String.format("The the date time value of [%s] could not be parsed with a locale of [%s]", dateTime, locale.getDisplayName()), e);
        }
        this.wrapped = parsed;
    }

    public DateTime(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second, Integer milliseconds, ZoneId timezone) {
        this(ZonedDateTime.of(year, month, day, hour, minute, second, milliseconds * 1000000, timezone == null ? ZoneId.systemDefault() : timezone));
    }

    public DateTime(Integer year, Integer month, Integer day) {
        this(year, month, day, null);
    }

    public DateTime(Integer year, Integer month, Integer day, ZoneId timezone) {
        this(ZonedDateTime.of(year, month, day, 0, 0, 0, 0, timezone != null ? timezone : ZoneId.systemDefault()));
    }

    private static DateTimeFormatter getFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static DateTimeFormatter getDateTimeFormatter(String mask) {
        return (DateTimeFormatter)COMMON_FORMATTERS.getOrDefault(Key.of(mask + MODE_DATETIME), (Object)DateTimeFormatter.ofPattern(mask));
    }

    public DateTime setFormat(String mask) {
        this.formatter = DateTimeFormatter.ofPattern(mask);
        return this;
    }

    public DateTime setFormat(DateTimeFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new GenericMeta(this);
        }
        return this.$bx;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.wrapped, this.formatter);
    }

    @Override
    @BoxMemberExpose
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        return Objects.equals(this.wrapped, other.wrapped) && Objects.equals(this.formatter, other.formatter);
    }

    @Override
    public String toString() {
        if (this.formatter != null) {
            return this.formatter.format(this.wrapped);
        }
        return this.wrapped.toString();
    }

    @BoxMemberExpose
    public DateTime clone() {
        return this.clone(this.wrapped.getZone());
    }

    public DateTime clone(ZoneId timezone) {
        return new DateTime(ZonedDateTime.ofInstant(this.wrapped.toInstant(), timezone != null ? timezone : this.wrapped.getZone()));
    }

    public Boolean isLeapYear() {
        return Year.isLeap(this.wrapped.getYear());
    }

    public String format(String mask) {
        return this.format(Locale.getDefault(), mask);
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        return this.wrapped.format(formatter);
    }

    public String format(Locale locale, String mask) {
        if (mask == null) {
            return this.wrapped.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG).withLocale(locale));
        }
        return this.format(DateTime.getDateTimeFormatter(mask).withLocale(locale));
    }

    @BoxMemberExpose
    public String toISOString() {
        this.formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        return this.toString();
    }

    @BoxMemberExpose
    public Long toEpoch() {
        return this.wrapped.toEpochSecond();
    }

    @BoxMemberExpose
    public Long toEpochMillis() {
        return this.wrapped.toInstant().toEpochMilli();
    }

    public DateTime modify(String unit, Long quantity) {
        switch (unit) {
            case "d": 
            case "y": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusDays(quantity) : this.wrapped.minusDays(Math.abs(quantity));
                break;
            }
            case "yyyy": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusYears(quantity) : this.wrapped.minusYears(Math.abs(quantity));
                break;
            }
            case "q": {
                Long multiplier = 3L;
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusMonths(quantity * multiplier) : this.wrapped.minusMonths(Math.abs(quantity) * multiplier);
                break;
            }
            case "m": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusMonths(quantity) : this.wrapped.minusMonths(Math.abs(quantity));
                break;
            }
            case "w": {
                Integer dayOfWeek = this.wrapped.getDayOfWeek().getValue();
                switch (dayOfWeek) {
                    case 5: {
                        quantity = quantity + 2L;
                        break;
                    }
                    case 6: {
                        quantity = quantity + 1L;
                    }
                }
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusDays(quantity) : this.wrapped.minusDays(Math.abs(quantity));
                break;
            }
            case "ww": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusWeeks(quantity) : this.wrapped.minusWeeks(Math.abs(quantity));
                break;
            }
            case "h": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusHours(quantity) : this.wrapped.minusHours(Math.abs(quantity));
                break;
            }
            case "n": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusMinutes(quantity) : this.wrapped.minusMinutes(Math.abs(quantity));
                break;
            }
            case "s": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plusSeconds(quantity) : this.wrapped.minusSeconds(Math.abs(quantity));
                break;
            }
            case "l": {
                this.wrapped = Long.signum(quantity) == 1 ? this.wrapped.plus(quantity, ChronoUnit.MILLIS) : this.wrapped.minus(Math.abs(quantity), ChronoUnit.MILLIS);
            }
        }
        return this;
    }

    public DateTime convertToZone(ZoneId timezone) {
        return new DateTime(this.getWrapped().withZoneSameInstant(timezone));
    }

    public DateTime setTimezone(String timeZone) {
        return this.setTimezone(ZoneId.of(timeZone));
    }

    public DateTime setTimezone(ZoneId zoneId) {
        this.wrapped = this.wrapped.withZoneSameLocal(zoneId);
        return this;
    }

    public ZonedDateTime getWrapped() {
        return this.wrapped;
    }

    @BoxMemberExpose
    public Long getTime() {
        return this.toEpochMillis();
    }

    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        DynamicInteropService.setField(this, key.getName().toLowerCase(), value);
        return this;
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        try {
            return DynamicInteropService.getField(this, key.getName().toLowerCase()).get();
        }
        catch (NoSuchElementException e) {
            throw new BoxRuntimeException(String.format("The property [%s] does not exist or is not public in the class [%s].", key.getName(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.DATETIME);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        if (DynamicInteropService.hasMethodNoCase(this.getClass(), name.getName()).booleanValue()) {
            return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
        }
        if (DynamicInteropService.hasMethodNoCase(this.wrapped.getClass(), name.getName()).booleanValue()) {
            return DynamicInteropService.invoke(context, this.wrapped, name.getName(), safe, positionalArguments);
        }
        if (DynamicInteropService.hasMethodNoCase(this.getClass(), "get" + name.getName()).booleanValue()) {
            return DynamicInteropService.invoke(context, this.wrapped, "get" + name.getName(), safe, positionalArguments);
        }
        throw new BoxRuntimeException(String.format("The method [%s] is not present in the [%s] object", name.getName(), this.getClass().getSimpleName()));
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.DATETIME);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        if (DynamicInteropService.hasMethodNoCase(this.getClass(), name.getName()).booleanValue()) {
            return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
        }
        if (DynamicInteropService.hasMethodNoCase(this.wrapped.getClass(), name.getName()).booleanValue()) {
            return DynamicInteropService.invoke(context, this.wrapped, name.getName(), safe, new Object[0]);
        }
        if (DynamicInteropService.hasMethodNoCase(this.getClass(), "get" + name.getName()).booleanValue()) {
            return DynamicInteropService.invoke(context, this.wrapped, "get" + name.getName(), safe, new Object[0]);
        }
        throw new BoxRuntimeException(String.format("The method [%s] is not present in the [%s] object", name.getName(), this.getClass().getSimpleName()));
    }

    @Override
    public int compareTo(ChronoZonedDateTime<?> other) {
        if (other instanceof DateTime) {
            DateTime castedDateTime = (DateTime)other;
            return this.getWrapped().compareTo(castedDateTime.getWrapped());
        }
        if (other instanceof ZonedDateTime) {
            ZonedDateTime castedDateTime = (ZonedDateTime)other;
            return this.getWrapped().compareTo(castedDateTime);
        }
        return this.getWrapped().compareTo(DateTimeCaster.cast(other).getWrapped());
    }

    @Override
    public void writeValue(JSONWriter context, JsonGenerator g, Object value) throws IOException {
        DateTime dateTime = (DateTime)value;
        g.writeString(dateTime.toISOString());
    }

    @Override
    public Class<?> valueType() {
        return DateTime.class;
    }

    @Override
    public Chronology getChronology() {
        return this.wrapped.getChronology();
    }

    @Override
    public int get(TemporalField field) {
        return this.wrapped.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        return this.wrapped.getLong(field);
    }

    @Override
    public ZoneOffset getOffset() {
        return this.wrapped.getOffset();
    }

    @Override
    public boolean isAfter(ChronoZonedDateTime<?> other) {
        return this.wrapped.isAfter(other);
    }

    @Override
    public boolean isBefore(ChronoZonedDateTime<?> other) {
        return this.wrapped.isBefore(other);
    }

    @Override
    public boolean isEqual(ChronoZonedDateTime<?> other) {
        return this.wrapped.isEqual(other);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return this.wrapped.isSupported(field);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        return this.wrapped.isSupported(unit);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> minus(long amountToSubtract, TemporalUnit unit) {
        return this.wrapped.minus(amountToSubtract, unit);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> minus(TemporalAmount amount) {
        return this.wrapped.minus(amount);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> plus(long amountToSubtract, TemporalUnit unit) {
        return this.wrapped.plus(amountToSubtract, unit);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> plus(TemporalAmount amount) {
        return this.wrapped.plus(amount);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        return this.wrapped.query(query);
    }

    @Override
    public ValueRange range(TemporalField field) {
        return this.wrapped.range(field);
    }

    @Override
    @BoxMemberExpose
    public long toEpochSecond() {
        return this.wrapped.toEpochSecond();
    }

    @Override
    public Instant toInstant() {
        return this.wrapped.toInstant();
    }

    @Override
    public LocalDate toLocalDate() {
        return this.wrapped.toLocalDate();
    }

    @Override
    public ChronoLocalDateTime<LocalDate> toLocalDateTime() {
        return this.wrapped.toLocalDateTime();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.wrapped.toLocalTime();
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return this.wrapped.until(endExclusive, unit);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> with(TemporalAdjuster adjuster) {
        return this.wrapped.with(adjuster);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> with(TemporalField field, long newValue) {
        return this.wrapped.with(field, newValue);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> withEarlierOffsetAtOverlap() {
        return this.wrapped.withEarlierOffsetAtOverlap();
    }

    @Override
    public ChronoZonedDateTime<LocalDate> withLaterOffsetAtOverlap() {
        return this.wrapped.withLaterOffsetAtOverlap();
    }

    @Override
    public ChronoZonedDateTime<LocalDate> withZoneSameInstant(ZoneId zone) {
        return this.wrapped.withZoneSameInstant(zone);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> withZoneSameLocal(ZoneId zone) {
        return this.wrapped.withZoneSameLocal(zone);
    }

    @Override
    public ZoneId getZone() {
        return this.wrapped.getZone();
    }
}

