/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.function.BiFunction;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class DynamicFunction
extends UDF {
    private static final Argument[] EMPTY_ARGUMENTS = new Argument[0];
    private Key name;
    private String hint = "Dynamic BoxLang Function";
    private String returnType = "any";
    private Argument[] arguments = EMPTY_ARGUMENTS;
    private IStruct annotations = Struct.EMPTY;
    private IStruct documentation = Struct.of(new Object[]{"hint", "I am a dynamic BoxLang function. I can be used to generate a function dynamically using Java or BoxLang."});
    private Instant createdOn = Instant.now();
    private BiFunction<FunctionBoxContext, DynamicFunction, Object> target;

    public DynamicFunction(Key name, BiFunction<FunctionBoxContext, DynamicFunction, Object> target, Argument[] arguments, String returnType, String hint, IStruct annotations) {
        this.name = name;
        this.target = target;
        this.returnType = returnType;
        this.arguments = arguments;
        this.annotations = annotations;
        this.documentation.put("hint", (Object)hint);
    }

    public DynamicFunction(Key name, BiFunction<FunctionBoxContext, DynamicFunction, Object> target) {
        this.name = name;
        this.target = target;
    }

    public DynamicFunction(Key name, BiFunction<FunctionBoxContext, DynamicFunction, Object> target, String returnType) {
        this.name = name;
        this.target = target;
        this.returnType = returnType;
    }

    @Override
    public Object _invoke(FunctionBoxContext context) {
        return this.target.apply(context, this);
    }

    @Override
    public Key getName() {
        return this.name;
    }

    @Override
    public Argument[] getArguments() {
        return this.arguments;
    }

    @Override
    public List<ImportDefinition> getImports() {
        return List.of();
    }

    @Override
    public ResolvedFilePath getRunnablePath() {
        return ResolvedFilePath.of(Path.of("dynamic-boxlang-function", new String[0]));
    }

    @Override
    public BoxSourceType getSourceType() {
        return BoxSourceType.BOXSCRIPT;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public IStruct getAnnotations() {
        return this.annotations;
    }

    @Override
    public IStruct getDocumentation() {
        return this.documentation;
    }

    @Override
    public Function.Access getAccess() {
        return Function.Access.PUBLIC;
    }

    @Override
    public long getRunnableCompileVersion() {
        return 0L;
    }

    @Override
    public LocalDateTime getRunnableCompiledOn() {
        return LocalDateTime.ofInstant(this.createdOn, ZoneId.systemDefault());
    }

    @Override
    public Object getRunnableAST() {
        return null;
    }
}

