/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.NoSuchElementException;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BoxMemberExpose;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.GenericMeta;
import ortus.boxlang.runtime.util.FileSystemUtil;

public class File
implements IType,
IReferenceable {
    private static final String MODE_READ = "read";
    private static final String MODE_READBINARY = "readbinary";
    private static final String MODE_WRITE = "write";
    private static final String MODE_APPEND = "append";
    private static final String CHARSET_UTF8 = "utf-8";
    protected BufferedReader reader = null;
    protected BufferedWriter writer = null;
    protected SeekableByteChannel byteChannel = null;
    protected final Path path;
    private static final String lineSeparator = System.getProperty("line.separator");
    public final String mode;
    public String filename;
    public String filepath;
    public DateTime lastModified;
    public String directory;
    public Long size;
    public String status;
    public String charset;
    public Boolean seekable;
    public BoxMeta $bx;
    private static final FunctionService functionService = BoxRuntime.getInstance().getFunctionService();

    public File(String file) {
        this(file, MODE_READ);
    }

    public File(String file, String mode) {
        this(file, mode, CHARSET_UTF8, mode.contains(MODE_READ));
    }

    public File(String file, String mode, String charset, Boolean seekable) {
        this.mode = mode;
        if (file.toLowerCase().indexOf("http") == 0) {
            try {
                URL fileURL = URI.create(file).toURL();
                this.path = Path.of(fileURL.toURI());
            }
            catch (URISyntaxException e) {
                throw new BoxRuntimeException("The url [" + file + "] could not be parsed.  The reason was:" + e.getMessage() + "(" + String.valueOf(e.getCause()) + ")");
            }
            catch (MalformedURLException e) {
                throw new BoxRuntimeException("The url [" + file + "] could not be parsed.  The reason was:" + e.getMessage() + "(" + String.valueOf(e.getCause()) + ")");
            }
        } else {
            this.path = Path.of(file, new String[0]);
        }
        this.charset = charset != null ? charset : CHARSET_UTF8;
        if (seekable != null) {
            this.seekable = seekable;
        } else {
            switch (mode) {
                case "read": 
                case "readbinary": {
                    this.seekable = true;
                    break;
                }
                default: {
                    this.seekable = false;
                }
            }
        }
        this.filename = this.path.getFileName().toString();
        this.filepath = this.path.toAbsolutePath().toString();
        this.directory = this.path.getParent().toAbsolutePath().toString();
        try {
            switch (mode) {
                case "read": {
                    if (!Files.isReadable(this.path)) {
                        throw new BoxRuntimeException("The file [" + this.path.toAbsolutePath().toString() + "] does not exist or is not readable.");
                    }
                    this.size = Files.size(this.path);
                    this.reader = Files.newBufferedReader(this.path, Charset.forName(charset));
                    break;
                }
                case "readbinary": {
                    if (!Files.isReadable(this.path)) {
                        throw new BoxRuntimeException("The file [" + this.path.toAbsolutePath().toString() + "] does not exist or is not readable.");
                    }
                    if (!FileSystemUtil.isBinaryFile(file).booleanValue()) {
                        throw new BoxRuntimeException("The file [" + this.path.toAbsolutePath().toString() + "] is not a binary file.");
                    }
                    this.size = Files.size(this.path);
                    this.byteChannel = Files.newByteChannel(this.path, StandardOpenOption.READ);
                    break;
                }
                case "write": {
                    if (this.seekable.booleanValue()) {
                        this.byteChannel = Files.newByteChannel(this.path, Files.exists(this.path, new LinkOption[0]) ? StandardOpenOption.WRITE : StandardOpenOption.CREATE_NEW);
                        break;
                    }
                    this.writer = Files.newBufferedWriter(this.path, Files.exists(this.path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE_NEW);
                    break;
                }
                case "append": {
                    this.writer = Files.newBufferedWriter(this.path, Files.exists(this.path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE_NEW);
                    break;
                }
                default: {
                    throw new BoxRuntimeException("The mode provided, [" + mode + "] for this file [" + this.filepath + "] is not valid");
                }
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new BoxRuntimeException("The charset [" + charset + "] is invalid");
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public Boolean isEOF() {
        Boolean isEOF = false;
        if (this.byteChannel != null) {
            try {
                return this.byteChannel.position() == this.byteChannel.size();
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        if (this.reader != null) {
            try {
                this.reader.mark(2);
                isEOF = (long)this.reader.read() == -1L;
                this.reader.reset();
            }
            catch (IOException e) {
                isEOF = true;
            }
        } else {
            throw new BoxRuntimeException("This file object is in write or append mode.  Unable to determine EOF.");
        }
        return isEOF;
    }

    public String readLine() {
        if (this.reader == null) {
            throw new BoxRuntimeException("This file object was not opened in read mode");
        }
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public Object read(Integer len) {
        try {
            if (this.reader != null) {
                CharBuffer buffer = CharBuffer.allocate(len);
                this.reader.read(buffer);
                return buffer.toString();
            }
            if (this.byteChannel != null) {
                ByteBuffer buffer = ByteBuffer.allocate(len);
                this.byteChannel.read(ByteBuffer.allocate(len));
                return buffer.array();
            }
            throw new BoxRuntimeException("This file object was not opened in read mode");
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public File seek(Integer offset) {
        if (!this.seekable.booleanValue()) {
            throw new BoxRuntimeException("This file instance was opened with the seekable argument set to false. This operation for file [" + this.filepath + "] is not allowed");
        }
        if (this.byteChannel != null) {
            try {
                this.byteChannel.position(LongCaster.cast(offset));
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        try {
            this.reader.skip(offset.intValue());
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        catch (NullPointerException e) {
            throw new BoxRuntimeException("This file object was not opened in read mode");
        }
        return this;
    }

    public File setLastModifiedTime(DateTime time) {
        try {
            Files.setLastModifiedTime(this.path, FileTime.from(time.toInstant()));
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        return this;
    }

    @BoxMemberExpose
    public DateTime getLastModifedTime() {
        try {
            return new DateTime(Files.getLastModifiedTime(this.path, new LinkOption[0]).toInstant());
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public File writeLine(String content) {
        block7: {
            try {
                Boolean isNewFile = LongCaster.cast(Files.size(this.path)).equals(0L);
                if (this.byteChannel != null) {
                    if (isNewFile.booleanValue()) {
                        this.byteChannel.write(ByteBuffer.wrap(content.getBytes()));
                    } else {
                        this.byteChannel.write(ByteBuffer.wrap((lineSeparator + content).getBytes()));
                    }
                    break block7;
                }
                if (this.writer != null) {
                    if (!isNewFile.booleanValue()) {
                        this.writer.newLine();
                    }
                    this.writer.append(content);
                    this.writer.flush();
                    break block7;
                }
                throw new BoxRuntimeException("This file object is not writeable.  Operation disallowed.");
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        return this;
    }

    public File append(String content) {
        try {
            if (this.byteChannel != null) {
                this.byteChannel.write(ByteBuffer.wrap(content.getBytes()));
            } else {
                this.writer.append(content);
                this.writer.flush();
            }
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        return this;
    }

    @BoxMemberExpose
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.byteChannel != null) {
                this.byteChannel.close();
            }
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new GenericMeta(this);
        }
        return this.$bx;
    }

    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        DynamicInteropService.setField(this, key.getName().toLowerCase(), value);
        return this;
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        try {
            return DynamicInteropService.getField(this, key.getName().toLowerCase()).get();
        }
        catch (NoSuchElementException e) {
            throw new BoxRuntimeException("The property [" + key.getName() + "] does not exist or is not public in the class [" + this.getClass().getSimpleName() + "].");
        }
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.FILE);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.FILE);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
    }
}

